/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.handler;

import java.net.URI;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.rx.Completable;

public class LbRouteHandler
implements RouteHandler {
    @Override
    public String[] schemas() {
        return new String[]{"lb"};
    }

    @Override
    public Completable handle(ExContext ctx) {
        URI targetUri = ctx.targetNew();
        String tmp = LoadBalance.get((String)targetUri.getHost()).getServer(targetUri.getPort());
        if (tmp == null) {
            throw new StatusException("The target service does not exist", 404);
        }
        targetUri = URI.create(tmp);
        ctx.targetNew(targetUri);
        RouteHandler handler = RouteFactoryManager.getHandler(targetUri.getScheme());
        if (handler == null) {
            throw new StatusException("The target handler does not exist", 404);
        }
        return handler.handle(ctx);
    }
}

