/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.integration;

import java.net.URI;
import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.properties.DiscoverProperties;
import org.noear.solon.cloud.gateway.properties.GatewayProperties;
import org.noear.solon.cloud.gateway.properties.RouteProperties;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteSpec;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.bean.LifecycleBean;

public class GatewayLocator
implements LifecycleBean {
    private final CloudRouteRegister routeRegister;
    private final GatewayProperties gatewayProperties;

    public GatewayLocator(GatewayProperties gatewayProperties, CloudRouteRegister routeRegister) {
        this.routeRegister = routeRegister;
        this.gatewayProperties = gatewayProperties;
    }

    public void start() {
        this.loadRoutesConfig();
        if (this.gatewayProperties.getDiscover().isEnabled()) {
            this.loadDiscoverConfig();
        }
    }

    private void loadDiscoverConfig() {
        Collection serviceNames;
        DiscoverProperties discover = this.gatewayProperties.getDiscover();
        if (Utils.isNotEmpty(discover.getIncludedServices())) {
            for (String tmp : discover.getIncludedServices()) {
                this.register(tmp);
            }
        }
        if (Utils.isNotEmpty((Collection)(serviceNames = CloudClient.discovery().findServices("")))) {
            for (String name : serviceNames) {
                this.register(name);
            }
        }
    }

    private void register(String serviceName) {
        if (this.gatewayProperties.getDiscover().getExcludedServices().contains(serviceName)) {
            return;
        }
        this.routeRegister.route(serviceName, r -> r.path("/" + serviceName + "/**").target("lb://" + serviceName));
        LoadBalance.get((String)serviceName);
    }

    public void loadRoutesConfig() {
        if (Utils.isEmpty(this.gatewayProperties.getRoutes())) {
            return;
        }
        for (RouteProperties rm : this.gatewayProperties.getRoutes()) {
            RouteSpec route = new RouteSpec(rm.getId());
            route.index(rm.getIndex());
            route.target(URI.create(rm.getTarget()));
            if ("lb".equals(route.getTarget().getScheme())) {
                LoadBalance.get((String)route.getTarget().getHost());
            }
            if (rm.getPredicates() != null) {
                for (String predicateStr : rm.getPredicates()) {
                    route.predicate(RouteFactoryManager.buildPredicate(predicateStr));
                }
            }
            if (rm.getFilters() != null) {
                for (String filterStr : rm.getFilters()) {
                    route.filter(RouteFactoryManager.buildFilter(filterStr));
                }
            }
            if (rm.getTimeout() != null) {
                route.timeout(rm.getTimeout());
            } else {
                route.timeout(this.gatewayProperties.getHttpClient());
            }
            this.routeRegister.route(route);
        }
    }
}

