/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.gateway.exchange.ExBody;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfBuffer;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfStream;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.CompletableEmitter;

public class HttpRouteHandler
implements RouteHandler {
    private WebClient httpClient;

    public HttpRouteHandler() {
        Solon.context().getBeanAsync(Vertx.class, b -> {
            WebClientOptions options = new WebClientOptions().setMaxPoolSize(250).setConnectTimeout(3000).setIdleTimeout(60).setKeepAlive(true).setKeepAliveTimeout(60);
            this.httpClient = WebClient.create((Vertx)b, (WebClientOptions)options);
        });
    }

    @Override
    public String[] schemas() {
        return new String[]{"http", "https"};
    }

    @Override
    public Completable handle(ExContext ctx) {
        try {
            HttpRequest<Buffer> req1 = this.buildHttpRequest(ctx);
            for (KeyValues kv : ctx.newRequest().getHeaders()) {
                if ("Host".equals(kv.getKey())) {
                    req1.putHeader("X-Forwarded-Host", (Iterable)kv.getValues());
                    continue;
                }
                req1.putHeader(kv.getKey(), (Iterable)kv.getValues());
            }
            if (ctx.rawHeader("X-Real-IP") == null) {
                req1.putHeader("X-Real-IP", ctx.realIp());
            }
            ExBody exBody = ctx.newRequest().getBody();
            return Completable.create(emitter -> {
                if (exBody instanceof ExBodyOfBuffer) {
                    req1.sendBuffer(((ExBodyOfBuffer)exBody).getBuffer(), ar1 -> this.callbackHandle(ctx, (AsyncResult<HttpResponse<Buffer>>)ar1, (CompletableEmitter)emitter));
                } else {
                    req1.sendStream(((ExBodyOfStream)exBody).getStream(), ar1 -> this.callbackHandle(ctx, (AsyncResult<HttpResponse<Buffer>>)ar1, (CompletableEmitter)emitter));
                }
            });
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Completable.error((Throwable)ex);
            }
            return Completable.error((Throwable)new StatusException(ex, 400));
        }
    }

    private HttpRequest<Buffer> buildHttpRequest(ExContext ctx) {
        RequestOptions requestOptions = new RequestOptions();
        if (ctx.timeout() != null) {
            requestOptions.setConnectTimeout((long)(ctx.timeout().getConnectTimeout() * 1000));
            requestOptions.setTimeout((long)(ctx.timeout().getResponseTimeout() * 1000));
        }
        requestOptions.setAbsoluteURI(ctx.targetNew() + ctx.newRequest().getPathAndQueryString());
        return this.httpClient.request(HttpMethod.valueOf((String)ctx.newRequest().getMethod()), requestOptions);
    }

    private void callbackHandle(ExContext ctx, AsyncResult<HttpResponse<Buffer>> ar, CompletableEmitter subscriber) {
        try {
            if (ar.succeeded()) {
                HttpResponse resp1 = (HttpResponse)ar.result();
                ctx.newResponse().status(resp1.statusCode());
                for (Map.Entry kv : resp1.headers()) {
                    ctx.newResponse().headerAdd((String)kv.getKey(), (String)kv.getValue());
                }
                ctx.newResponse().body((Buffer)resp1.body());
                subscriber.onComplete();
            } else {
                subscriber.onError(ar.cause());
            }
        }
        catch (Throwable ex) {
            subscriber.onError(ex);
        }
    }
}

