/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.spymemcached;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCacheService
implements CacheService {
    static final Logger log = LoggerFactory.getLogger(MemCacheService.class);
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected boolean _enableMd5key = true;
    protected final MemcachedClient client;

    public MemCacheService enableMd5key(boolean enable) {
        this._enableMd5key = enable;
        return this;
    }

    public MemCacheService(MemcachedClient client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public MemCacheService(MemcachedClient client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public MemCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public MemCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
        builder.setProtocol(ConnectionFactoryBuilder.Protocol.BINARY);
        try {
            if (Utils.isNotEmpty((String)user) && Utils.isNotEmpty((String)password)) {
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(user, password));
                builder.setAuthDescriptor(ad);
            }
            this.client = new MemcachedClient(builder.build(), AddrUtil.getAddresses((String)server));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MemcachedClient client() {
        return this.client;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (seconds < 1) {
            seconds = this._defaultSeconds;
        }
        String newKey = this.newKey(key);
        try {
            this.client.set(newKey, seconds, obj);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T get(String key, Type type) {
        String newKey = this.newKey(key);
        try {
            return (T)this.client.get(newKey);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void remove(String key) {
        String newKey = this.newKey(key);
        this.client.delete(newKey);
    }

    protected String newKey(String key) {
        if (this._cacheKeyHead == null) {
            if (this._enableMd5key) {
                return Utils.md5((String)key);
            }
            return key;
        }
        if (this._enableMd5key) {
            return this._cacheKeyHead + ":" + Utils.md5((String)key);
        }
        return this._cacheKeyHead + ":" + key;
    }
}

