/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;

public class CaffeineCacheService
implements CacheService {
    private final Cache<String, Object> client;
    private final ReentrantLock lock = new ReentrantLock();
    private MyExpiry expiry;
    private String _cacheKeyHead;
    private int _defaultSeconds;

    public CaffeineCacheService(Cache<String, Object> client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public CaffeineCacheService(Cache<String, Object> client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public CaffeineCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public CaffeineCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this.expiry = new MyExpiry(this._defaultSeconds);
        this.client = Caffeine.newBuilder().expireAfter((Expiry)this.expiry).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String key, Object obj, int seconds) {
        this.lock.lock();
        try {
            this.expiry.setSupplier(() -> TimeUnit.SECONDS.toNanos(seconds));
            this.client.put((Object)key, obj);
            this.expiry.setSupplier(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String key) {
        this.client.invalidate((Object)key);
    }

    public <T> T get(String key, Type type) {
        return (T)this.client.getIfPresent((Object)key);
    }

    public <T> T getOrStore(String key, Type type, int seconds, Supplier<T> supplier) {
        return (T)this.client.get((Object)key, k -> supplier.get());
    }

    private static class MyExpiry
    implements Expiry<String, Object> {
        private final int defaultSeconds;
        private volatile Supplier<Long> customExpirySupplier;

        public MyExpiry(int seconds) {
            this.defaultSeconds = seconds;
        }

        public void setSupplier(Supplier<Long> supplier) {
            this.customExpirySupplier = supplier;
        }

        public long expireAfterCreate(String key, Object value, long currentTime) {
            return this.getExpireNanos();
        }

        public long expireAfterUpdate(String key, Object value, long currentTime, long currentDuration) {
            return this.getExpireNanos();
        }

        public long expireAfterRead(String key, Object value, long currentTime, long currentDuration) {
            return currentDuration;
        }

        private long getExpireNanos() {
            Supplier<Long> supplier = this.customExpirySupplier;
            if (supplier != null) {
                return supplier.get();
            }
            return TimeUnit.SECONDS.toNanos(this.defaultSeconds);
        }
    }
}

