/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx;

import io.vertx.core.Vertx;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.vertx.VxHttpServerComb;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ThreadsUtil;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    private Vertx _vertx;
    private VxHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "vertx-http/" + Solon.version();
    }

    public void start(AppContext context) throws Throwable {
        if (!Solon.app().enableHttp()) {
            return;
        }
        this._vertx = Vertx.vertx();
        context.wrapAndPut(Vertx.class, (Object)this._vertx);
        context.lifecycle(99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        HttpServerProps props = HttpServerProps.getInstance();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new VxHttpServerComb();
        this._server.enableWebSocket(app.enableWebSocket());
        if (props.isIoBound()) {
            if (Solon.cfg().isEnabledVirtualThreads()) {
                this._server.setExecutor(ThreadsUtil.newVirtualThreadPerTaskExecutor());
            } else {
                this._server.setExecutor(props.getBioExecutor("smarthttp-"));
            }
        }
        if (props.isIoBound()) {
            if (Solon.cfg().isEnabledVirtualThreads()) {
                this._server.setExecutor(ThreadsUtil.newVirtualThreadPerTaskExecutor());
            } else {
                this._server.setExecutor(props.getBioExecutor("vertxhttp-"));
            }
        }
        this._server.setHandler(arg_0 -> ((SolonApp)Solon.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info("Connector:main: vertx-http: Started ServerConnector@{HTTP/1.1,[http/1.1]}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: vertx-http: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
        }
        if (this._vertx != null) {
            this._vertx.close();
            this._vertx = null;
        }
    }
}

