/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.boot.undertow.websocket.CallbackFuture;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;

public class WebSocketImpl
extends WebSocketBase {
    private WebSocketChannel real;

    public WebSocketImpl(WebSocketChannel real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getUrl());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getDestinationAddress();
    }

    public long getIdleTimeout() {
        return this.real.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(idleTimeout);
    }

    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendText((String)text, (WebSocketChannel)this.real, (WebSocketCallback)future);
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendBinary((ByteBuffer)binary, (WebSocketChannel)this.real, (WebSocketCallback)future);
        return future;
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((WebSocketChannel)this.real).close());
    }
}

