/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.smarthttp.http.SmHttpContext;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.smartboot.http.common.multipart.MultipartConfig;
import org.smartboot.http.common.multipart.Part;
import org.smartboot.http.server.HttpRequest;

public class MultipartUtil {
    static MultipartConfig multipartConfig;

    public static void init() throws IOException {
        if (multipartConfig == null) {
            if (ServerProps.request_useTempfile) {
                long _maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : 0L;
                long _maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : 0L;
                int _fileOutputBuffer = 0;
                _maxBodySize = Math.max(_maxBodySize, _maxFileSize);
                String tempdir = Files.createTempDirectory("smarthttp.upload", new FileAttribute[0]).toFile().getCanonicalPath();
                multipartConfig = new MultipartConfig(tempdir, _maxFileSize, _maxBodySize, _fileOutputBuffer);
            } else {
                multipartConfig = new MultipartConfig();
            }
        }
    }

    public static void buildParamsAndFiles(SmHttpContext ctx, MultiMap<UploadedFile> filesMap) {
        try {
            HttpRequest request = (HttpRequest)ctx.request();
            for (Part part : request.getParts(multipartConfig)) {
                String name = ServerProps.urlDecode((String)part.getName());
                if (MultipartUtil.isFile(part)) {
                    MultipartUtil.doBuildFiles(name, filesMap, part);
                    continue;
                }
                ctx.paramMap().add(name, (Object)IoUtil.transferToString((InputStream)part.getInputStream(), (String)ServerProps.request_encoding));
            }
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)ctx, e);
        }
    }

    public static StatusException status4xx(Context ctx, Exception e) {
        if (e instanceof StatusException) {
            return (StatusException)e;
        }
        if (MultipartUtil.isBodyLargerEx(e)) {
            return new StatusException("Request Entity Too Large: " + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 413);
        }
        return new StatusException("Bad Request:" + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 400);
    }

    private static void doBuildFiles(String name, MultiMap<UploadedFile> filesMap, Part part) throws IOException {
        KeyValues list = filesMap.holder(name);
        String contentType = part.getContentType();
        long contentSize = part.getSize();
        InputStream content = part.getInputStream();
        String fileName = part.getSubmittedFileName();
        String extension = null;
        int idx = fileName.lastIndexOf(".");
        if (idx > 0) {
            extension = fileName.substring(idx + 1);
        }
        UploadedFile f1 = new UploadedFile(() -> ((Part)part).delete(), contentType, contentSize, content, fileName, extension);
        list.addValue((Object)f1);
    }

    private static boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private static boolean isFile(Part filePart) {
        return !MultipartUtil.isField(filePart);
    }

    public static boolean isBodyLargerEx(Throwable e) {
        return MultipartUtil.hasLargerStr(e) || MultipartUtil.hasLargerStr(e.getCause());
    }

    private static boolean hasLargerStr(Throwable e) {
        if (e == null || e.getMessage() == null) {
            return false;
        }
        return e.getMessage().contains("Payload Too Large");
    }
}

