/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.smarthttp.http.MultipartUtil;
import org.noear.solon.boot.web.AsyncContextState;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;

public class SmHttpContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(SmHttpContext.class);
    private HttpRequest _request;
    private HttpResponse _response;
    private CompletableFuture<Object> _future;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private String queryString;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;
    protected final AsyncContextState asyncState = new AsyncContextState();

    protected HttpRequest innerGetRequest() {
        return this._request;
    }

    protected HttpResponse innerGetResponse() {
        return this._response;
    }

    public SmHttpContext(HttpRequest request, HttpResponse response, CompletableFuture<Object> future) {
        this._request = request;
        this._response = response;
        this._future = future;
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, (MultiMap<UploadedFile>)this._fileMap);
        }
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.getRemoteAddr();
    }

    public int remotePort() {
        return this._request.getRemoteAddress().getPort();
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL();
        }
        return this._url;
    }

    public long contentLength() {
        return this._request.getContentLength();
    }

    public String queryString() {
        try {
            if (this.queryString == null) {
                this.queryString = this._request.getQueryString();
                this.queryString = this.queryString == null ? "" : ServerProps.urlDecode((String)this.queryString);
            }
            return this.queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)this, e);
        }
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry entry : this._request.getParameters().entrySet()) {
                    String key = ServerProps.urlDecode((String)((String)entry.getKey()));
                    this._paramMap.holder(key).setValues((Object[])entry.getValue());
                }
            }
            catch (Exception e) {
                throw MultipartUtil.status4xx((Context)this, e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap();
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            for (String k : this._request.getHeaderNames()) {
                this._headerMap.holder(k).setValues(new ArrayList(this._request.getHeaders(k)));
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._response.getOutputStream();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getHeader(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._response.getHeaderNames();
    }

    public void cookieSet(Cookie cookie) {
        org.smartboot.http.common.Cookie c = new org.smartboot.http.common.Cookie(cookie.name, cookie.value);
        if (cookie.maxAge >= 0) {
            c.setMaxAge(cookie.maxAge);
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            c.setDomain(cookie.domain);
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            c.setPath(cookie.path);
        }
        c.setSecure(cookie.secure);
        c.setHttpOnly(cookie.httpOnly);
        this._response.addCookie(c);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void contentLength(long size) {
        this._response.setContentLength(size);
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._response.close();
    }

    protected void innerCommit() throws IOException {
        try {
            if (this.getHandled() || this.status() >= 200) {
                this.sendHeaders(true);
            } else {
                this.status(404);
                this.sendHeaders(true);
            }
        }
        finally {
            this._future.complete(null);
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setHttpStatus(HttpStatus.valueOf((int)this.status()));
            if (isCommit || !this._allows_write) {
                this._response.setContentLength(0L);
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this.asyncState.asyncDelay(timeout, (Context)this, this::innerCommit);
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart((Context)this);
        }
    }

    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncState.onComplete((Context)this);
            }
        }
    }
}

