/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.http.HttpServerConfigure;
import org.noear.solon.boot.jetty.http.JtContainerInitializer;
import org.noear.solon.boot.jetty.http.JtHttpContextServletHandler;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.ssl.SslConfig;
import org.noear.solon.boot.web.SessionProps;
import org.noear.solon.core.util.ResourceUtil;

abstract class JettyServerBase
implements ServerLifecycle,
HttpServerConfigure {
    protected final HttpServerProps props;
    protected Executor executor;
    protected SslConfig sslConfig = new SslConfig("http");
    protected boolean enableSessionState;
    protected boolean isSecure;
    protected Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();

    public JettyServerBase(HttpServerProps props) {
        this.props = props;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSessionState(boolean enableSessionState) {
        this.enableSessionState = enableSessionState;
    }

    public void enableSsl(boolean enable, SSLContext sslContext) {
        this.sslConfig.set(enable, null);
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected ServerConnector getConnector(Server server, String host, int port, boolean autoSsl) throws RuntimeException {
        ServerConnector serverConnector;
        HttpConfiguration config = new HttpConfiguration();
        if (ServerProps.request_maxHeaderSize > 0) {
            config.setRequestHeaderSize(ServerProps.request_maxHeaderSize);
        }
        config.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(config);
        if (this.sslConfig.isSslEnable() && autoSsl) {
            String sslKeyStore = this.sslConfig.getProps().getSslKeyStore();
            String sslKeyStoreType = this.sslConfig.getProps().getSslKeyType();
            String sslKeyStorePassword = this.sslConfig.getProps().getSslKeyPassword();
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            if (Utils.isNotEmpty((String)sslKeyStore)) {
                URL url = ResourceUtil.findResource((String)sslKeyStore);
                if (url != null) {
                    sslKeyStore = url.toString();
                }
                contextFactory.setKeyStorePath(sslKeyStore);
            }
            if (Utils.isNotEmpty((String)sslKeyStoreType)) {
                contextFactory.setKeyStoreType(sslKeyStoreType);
            }
            if (Utils.isNotEmpty((String)sslKeyStorePassword)) {
                contextFactory.setKeyStorePassword(sslKeyStorePassword);
            }
            SslConnectionFactory sslFactory = new SslConnectionFactory((SslContextFactory)contextFactory, HttpVersion.HTTP_1_1.asString());
            serverConnector = new ServerConnector(server, this.executor, null, null, -1, -1, new ConnectionFactory[]{sslFactory, httpFactory});
            this.isSecure = true;
        } else {
            serverConnector = new ServerConnector(server, this.executor, null, null, -1, -1, new ConnectionFactory[]{httpFactory});
        }
        serverConnector.setIdleTimeout(this.props.getIdleTimeoutOrDefault());
        serverConnector.setPort(port);
        if (Utils.isNotEmpty((String)host)) {
            serverConnector.setHost(host);
        }
        return serverConnector;
    }

    protected ServletContextHandler getServletHandler() throws IOException {
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        handler.addServlet(JtHttpContextServletHandler.class, "/").setAsyncSupported(true);
        if (this.enableSessionState) {
            handler.setSessionHandler(new SessionHandler());
            if (SessionProps.session_timeout > 0) {
                handler.getSessionHandler().setMaxInactiveInterval(SessionProps.session_timeout);
            }
        }
        handler.addLifeCycleListener((LifeCycle.Listener)new JtContainerInitializer((ServletContext)handler.getServletContext()));
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon.boot.jetty");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        handler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        return handler;
    }
}

