/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.noear.solon.boot.jetty.websocket.WebSocketImpl;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketListenerImpl
extends WebSocketAdapter
implements WebSocketPingPongListener {
    static final Logger log = LoggerFactory.getLogger(WebSocketListenerImpl.class);
    private WebSocketImpl webSocket;
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        session.getPolicy().setMaxTextMessageBufferSize(17000000);
        this.webSocket = new WebSocketImpl(session);
        session.getUpgradeRequest().getHeaders().forEach((k, v) -> {
            if (v.size() > 0) {
                this.webSocket.param((String)k, (String)v.get(0));
            }
        });
        this.webSocketRouter.getListener().onOpen((WebSocket)this.webSocket);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(payload, offset, len);
            this.webSocketRouter.getListener().onMessage((WebSocket)this.webSocket, buf);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onWebSocketText(String text) {
        try {
            this.webSocketRouter.getListener().onMessage((WebSocket)this.webSocket, text);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (this.webSocket.isClosed()) {
            return;
        }
        RunUtil.runAndTry(this.webSocket::close);
        this.webSocketRouter.getListener().onClose((WebSocket)this.webSocket);
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable cause) {
        this.webSocketRouter.getListener().onError((WebSocket)this.webSocket, cause);
    }

    public void onWebSocketPing(ByteBuffer byteBuffer) {
        this.webSocketRouter.getListener().onPing((WebSocket)this.webSocket);
    }

    public void onWebSocketPong(ByteBuffer byteBuffer) {
        this.webSocketRouter.getListener().onPong((WebSocket)this.webSocket);
    }
}

