/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.impl;

import java.util.Set;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.aot.graalvm.GraalvmUtil;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerExt
extends Scanner {
    static final Logger log = LoggerFactory.getLogger(ScannerExt.class);

    public Set<String> scan(ClassLoader classLoader, String path, boolean fileMode, Predicate<String> filter) {
        Set urls = super.scan(classLoader, path, fileMode, filter);
        if (!fileMode && NativeDetector.inNativeImage()) {
            GraalvmUtil.scanResource(path, filter, urls);
            if (Solon.cfg().isDebugMode()) {
                log.info("Native: Resource scan: " + urls.size() + ", path: " + path);
            }
            return urls;
        }
        return urls;
    }
}

