/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.aot.AppContextNativeProcessor;
import org.noear.solon.aot.NativeMetadataUtils;
import org.noear.solon.aot.RuntimeNativeMetadata;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.aot.Settings;
import org.noear.solon.aot.hint.ExecutableHint;
import org.noear.solon.aot.hint.ExecutableMode;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.aot.proxy.ProxyClassGenerator;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;

public class AppContextNativeProcessorDefault
implements AppContextNativeProcessor {
    public static final String AOT_PROXY_CLASSNAME_SUFFIX = "$$SolonAotProxy";
    public static final String ASM_PROXY_CLASSNAME_SUFFIX = "$$SolonAsmProxy";
    private final ProxyClassGenerator proxyClassGenerator = new ProxyClassGenerator();

    @Override
    public void process(AppContext context, Settings settings, RuntimeNativeMetadata metadata) {
        AtomicInteger beanCount = new AtomicInteger();
        context.beanForeach(beanWrap -> {
            if (RuntimeNativeRegistrar.class.isAssignableFrom(beanWrap.clz())) {
                return;
            }
            Class clz = beanWrap.clz();
            if (clz.isInterface()) {
                return;
            }
            beanCount.getAndIncrement();
            if (beanWrap.proxy() != null && settings != null) {
                this.proxyClassGenerator.generateCode(settings, clz);
            }
            if (beanWrap.clzInit() != null) {
                metadata.registerMethod(beanWrap.clzInit(), ExecutableMode.INVOKE);
            }
            if (beanWrap.clzDestroy() != null) {
                metadata.registerMethod(beanWrap.clzDestroy(), ExecutableMode.INVOKE);
            }
            this.processBeanDo(metadata, clz, beanWrap.proxy() != null);
            this.processBeanFieldsDo(metadata, clz);
        });
        context.methodForeach(methodWrap -> NativeMetadataUtils.registerMethodAndParamAndReturnType(metadata, methodWrap));
        for (Class clz : context.aot().getEntityTypes()) {
            if (clz.getName().startsWith("java.")) continue;
            metadata.registerReflection(clz, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS);
        }
        for (Class clz : context.aot().getJdkProxyTypes()) {
            if (clz.getName().startsWith("java.")) continue;
            metadata.registerJdkProxy(clz);
        }
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            metadata.registerReflection(drivers.nextElement().getClass(), MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        }
        metadata.registerReflection(InvocationHandler.class, MemberCategory.INVOKE_DECLARED_METHODS);
        LogUtil.global().info("Aot process bean, bean size: " + beanCount.get());
    }

    protected void processSerialization(RuntimeNativeMetadata metadata, Class<?> type) {
        if (!type.getName().startsWith("java.") && Serializable.class.isAssignableFrom(type)) {
            metadata.registerSerialization(type);
        }
    }

    protected void processBeanDo(RuntimeNativeMetadata nativeMetadata, Class<?> clazz, boolean supportProxy) {
        if (clazz.isEnum() || clazz.isAnnotation()) {
            return;
        }
        nativeMetadata.registerDefaultConstructor(clazz);
        for (Field field : ReflectUtil.getDeclaredFields(clazz)) {
            nativeMetadata.registerField(field);
        }
        nativeMetadata.registerReflection(clazz, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        if (supportProxy) {
            String proxyClassName = ReflectUtil.getClassName(clazz) + AOT_PROXY_CLASSNAME_SUFFIX;
            nativeMetadata.registerReflection(proxyClassName, hints -> hints.getConstructors().add(new ExecutableHint("<init>", new Class[]{InvocationHandler.class}, ExecutableMode.INVOKE)));
            nativeMetadata.registerReflection(proxyClassName, hints -> hints.getMemberCategories().addAll(Arrays.asList(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS)));
        }
    }

    protected void processMethodDo(RuntimeNativeMetadata nativeMetadata, Method method) {
        nativeMetadata.registerMethod(method, ExecutableMode.INVOKE);
    }

    protected void processBeanFieldsDo(RuntimeNativeMetadata nativeMetadata, Class<?> clazz) {
        ClassWrap clzWrap = ClassWrap.get(clazz);
        for (FieldWrap fieldWrap : clzWrap.getAllFieldWraps()) {
            this.processFieldDo(nativeMetadata, fieldWrap.getField());
        }
    }

    protected void processFieldDo(RuntimeNativeMetadata nativeMetadata, Field field) {
        nativeMetadata.registerField(field);
        nativeMetadata.registerReflection(field.getDeclaringClass(), MemberCategory.DECLARED_FIELDS);
    }
}

