/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot.proxy;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.noear.solon.aot.proxy.MethodFinder;
import org.noear.solon.aot.proxy.TypeNameUtil;
import org.noear.solon.core.util.GenericUtil;

public class ProxyClassFileBuilder {
    public static final String PROXY_CLASSNAME_SUFFIX = "$$SolonAotProxy";

    public JavaFile build(Class<?> typeElement) {
        Package packageElement = typeElement.getPackage();
        String packageName = packageElement.getName();
        String className = typeElement.getSimpleName();
        ClassName supperClassName = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        String proxyClassName = className + PROXY_CLASSNAME_SUFFIX;
        Map<String, Method> methodAll = MethodFinder.findMethodAll(typeElement);
        TypeSpec.Builder proxyTypeBuilder = TypeSpec.classBuilder((String)proxyClassName).superclass((TypeName)supperClassName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL});
        this.addConstructor(proxyTypeBuilder, typeElement, proxyClassName);
        if (methodAll.size() > 0) {
            this.addMethodAll(proxyTypeBuilder, typeElement, methodAll);
            this.addStaticBlock(proxyTypeBuilder, packageName, className, methodAll);
        }
        TypeSpec proxyType = proxyTypeBuilder.build();
        return JavaFile.builder((String)packageName, (TypeSpec)proxyType).build();
    }

    private void addConstructor(TypeSpec.Builder proxyTypeBuilder, Class<?> typeElement, String proxyClassName) {
        proxyTypeBuilder.addField(InvocationHandler.class, "handler", new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE});
        MethodSpec.Builder methodBuilder = MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        methodBuilder.addParameter(InvocationHandler.class, "handler", new javax.lang.model.element.Modifier[0]);
        methodBuilder.addParameter(Object[].class, "args", new javax.lang.model.element.Modifier[0]);
        Constructor<?> constructor = typeElement.getDeclaredConstructors()[0];
        if (constructor.getParameterCount() > 0) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            StringBuilder buf = new StringBuilder("super(");
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> t1 = parameterTypes[i];
                buf.append("(").append(t1.getName()).append(")args[").append(i).append("],");
            }
            buf.setLength(buf.length() - 1);
            buf.append(")");
            methodBuilder.addStatement(buf.toString(), new Object[0]);
        }
        methodBuilder.addStatement("this.handler = handler", new Object[0]);
        proxyTypeBuilder.addMethod(methodBuilder.build());
    }

    private void addStaticBlock(TypeSpec.Builder proxyTypeBuilder, String packageName, String className, Map<String, Method> methodAll) {
        int methodIndex = 0;
        StringBuilder codeBuilder = new StringBuilder(150);
        codeBuilder.append("try {\n");
        codeBuilder.append("  Class<?> clazz = $T.class;\n\n");
        for (Method methodElement : methodAll.values()) {
            if (!MethodFinder.allowMethod(methodElement)) continue;
            String methodFieldName = "  method" + methodIndex;
            codeBuilder.append(methodFieldName).append("=clazz.getMethod(\"").append(methodElement.getName()).append("\"");
            for (Parameter p0 : methodElement.getParameters()) {
                int p1NameIdx;
                String p1Name;
                Class<?> p1;
                if (p0.getParameterizedType() != null) {
                    p1 = p0.getType();
                    p1Name = p1.getTypeName();
                    p1NameIdx = p1Name.indexOf("<");
                    if (p1NameIdx > 0) {
                        p1Name = p1Name.substring(0, p1NameIdx);
                    }
                    if (p1 instanceof TypeVariable) {
                        codeBuilder.append(",Object.class");
                        continue;
                    }
                    codeBuilder.append(",").append(p1Name).append(".class");
                    continue;
                }
                p1 = p0.getType();
                p1Name = ((Object)p1).toString();
                p1NameIdx = p1Name.indexOf("<");
                if (p1NameIdx > 0) {
                    p1Name = p1Name.substring(0, p1NameIdx);
                }
                codeBuilder.append(",").append(p1Name).append(".class");
            }
            codeBuilder.append(");\n");
            ++methodIndex;
        }
        codeBuilder.append("} catch (Throwable e) {\n  throw new IllegalStateException(e);\n}\n");
        CodeBlock codeBlock = CodeBlock.of((String)codeBuilder.toString(), (Object[])new Object[]{ClassName.get((String)packageName, (String)className, (String[])new String[0])});
        proxyTypeBuilder.addStaticBlock(codeBlock);
    }

    private void addMethodAll(TypeSpec.Builder proxyTypeBuilder, Class<?> typeElement, Map<String, Method> methodAll) {
        int methodIndex = 0;
        Map typeGenericMap = GenericUtil.getGenericInfo(typeElement);
        for (Method e : methodAll.values()) {
            methodIndex = this.addMethod(proxyTypeBuilder, typeGenericMap, e, methodIndex);
        }
    }

    private int addMethod(TypeSpec.Builder proxyTypeBuilder, Map<String, Type> typeGenericMap, Method methodElement, int methodIndex) {
        if (!MethodFinder.allowMethod(methodElement)) {
            return methodIndex;
        }
        String methodFieldName = "method" + methodIndex;
        proxyTypeBuilder.addField(Method.class, methodFieldName, new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC});
        TypeName returnTypeName = TypeNameUtil.getTypeName(typeGenericMap, methodElement.getReturnType(), methodElement.getGenericReturnType());
        StringBuilder codeBuilder = new StringBuilder(150);
        boolean isPublic = Modifier.isPublic(methodElement.getModifiers());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodElement.getName().toString()).addModifiers(new javax.lang.model.element.Modifier[]{isPublic ? javax.lang.model.element.Modifier.PUBLIC : javax.lang.model.element.Modifier.PROTECTED}).addAnnotation(Override.class).returns(returnTypeName);
        for (Class<?> clazz : methodElement.getExceptionTypes()) {
            methodBuilder.addException(TypeName.get(clazz));
        }
        for (Type type : methodElement.getTypeParameters()) {
            TypeVariableName teName = TypeNameUtil.getTypeVariableName(typeGenericMap, (TypeVariable)type);
            methodBuilder.addTypeVariable(teName);
        }
        codeBuilder.append("handler.invoke(this, ").append(methodFieldName).append(", ").append("new Object[]{");
        for (Parameter parameter : methodElement.getParameters()) {
            TypeName paramType = TypeNameUtil.getTypeName(typeGenericMap, parameter.getType(), parameter.getParameterizedType());
            String paramName = parameter.getName();
            methodBuilder.addParameter(paramType, paramName, new javax.lang.model.element.Modifier[0]);
            codeBuilder.append(paramName).append(",");
        }
        if (codeBuilder.charAt(codeBuilder.length() - 1) == ',') {
            codeBuilder.setLength(codeBuilder.length() - 1);
        }
        codeBuilder.append("});");
        if (Void.TYPE.equals(methodElement.getReturnType())) {
            codeBuilder.insert(0, "try { \n  ");
            codeBuilder.append("\n} catch (RuntimeException _ex) {\n  throw _ex;\n} catch (Throwable _ex) {\n  throw new RuntimeException(_ex);\n}\n");
            methodBuilder.addCode(codeBuilder.toString(), new Object[0]);
        } else {
            codeBuilder.insert(0, "try { \n  return (" + returnTypeName + ")");
            codeBuilder.append("\n} catch (RuntimeException _ex) {\n  throw _ex;\n} catch (Throwable _ex) {\n  throw new RuntimeException(_ex);\n}\n");
            methodBuilder.addCode(codeBuilder.toString(), new Object[0]);
        }
        proxyTypeBuilder.addMethod(methodBuilder.build());
        return ++methodIndex;
    }

    public static String getClassName(Class<?> type, String packageName) {
        return type.getSimpleName().replace('.', '$');
    }
}

