/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.aot.hint.ExecutableHint;
import org.noear.solon.aot.hint.ExecutableMode;
import org.noear.solon.aot.hint.JdkProxyHint;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.aot.hint.ReflectionHints;
import org.noear.solon.aot.hint.ResourceHint;
import org.noear.solon.aot.hint.SerializationHint;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.util.ScanUtil;

public class RuntimeNativeMetadata {
    private final Options jsonOptions = Options.def().add(new Feature[]{Feature.PrettyFormat}).add(new Feature[]{Feature.OrderedField});
    private final Map<String, ReflectionHints> reflection = new LinkedHashMap<String, ReflectionHints>();
    private final Set<String> args = new TreeSet<String>();
    private final List<ResourceHint> includes = new ArrayList<ResourceHint>();
    private final List<ResourceHint> excludes = new ArrayList<ResourceHint>();
    private final Map<String, SerializationHint> serializations = new LinkedHashMap<String, SerializationHint>();
    private final Map<String, SerializationHint> lambdaSerializations = new LinkedHashMap<String, SerializationHint>();
    private final Map<String, JdkProxyHint> jdkProxys = new LinkedHashMap<String, JdkProxyHint>();
    private String applicationClassName;

    public RuntimeNativeMetadata registerArg(String ... args) {
        for (String arg : args) {
            this.args.add(arg);
        }
        return this;
    }

    public RuntimeNativeMetadata registerJdkProxy(Class<?> type) {
        return this.registerJdkProxy(type, null);
    }

    public RuntimeNativeMetadata registerJdkProxy(Class<?> type, String reachableType) {
        if (type.isInterface() && !type.isAnnotation()) {
            this.registerJdkProxyDo(type.getName(), reachableType);
        }
        return this;
    }

    private void registerJdkProxyDo(String typeName, String reachableType) {
        if (!this.jdkProxys.containsKey(typeName)) {
            JdkProxyHint proxyHint = new JdkProxyHint();
            proxyHint.setReachableType(reachableType);
            proxyHint.setInterfaces(Arrays.asList(typeName));
            this.jdkProxys.put(typeName, proxyHint);
        }
    }

    public RuntimeNativeMetadata registerReflection(String className, Consumer<ReflectionHints> typeHint) {
        if (Utils.isEmpty((String)className)) {
            return this;
        }
        ReflectionHints reflectionHints = this.getReflectionHints(className);
        typeHint.accept(reflectionHints);
        Class clazz = ClassUtil.loadClass((String)className);
        if (!className.startsWith("java.") && clazz != null) {
            try {
                Field[] fields;
                if (reflectionHints.getMemberCategories().contains((Object)MemberCategory.DECLARED_FIELDS)) {
                    Field[] declaredFields = clazz.getDeclaredFields();
                    if (Arrays.stream(declaredFields).allMatch(e -> ClassUtil.hasClass(e::getType))) {
                        for (Field declaredField : declaredFields) {
                            this.registerField(declaredField);
                        }
                    }
                } else if (reflectionHints.getMemberCategories().contains((Object)MemberCategory.PUBLIC_FIELDS) && Arrays.stream(fields = clazz.getFields()).allMatch(e -> ClassUtil.hasClass(e::getType))) {
                    for (Field field : fields) {
                        this.registerField(field);
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return this;
    }

    public RuntimeNativeMetadata registerReflection(Class<?> type, Consumer<ReflectionHints> typeHint) {
        return this.registerReflection(type.getName(), typeHint);
    }

    public RuntimeNativeMetadata registerReflection(Class<?> type, MemberCategory ... memberCategories) {
        return this.registerReflection(type, (ReflectionHints hints) -> hints.getMemberCategories().addAll(Arrays.asList(memberCategories)));
    }

    public RuntimeNativeMetadata registerReflection(String className, MemberCategory ... memberCategories) {
        return this.registerReflection(className, (ReflectionHints hints) -> hints.getMemberCategories().addAll(Arrays.asList(memberCategories)));
    }

    public RuntimeNativeMetadata registerField(Field field) {
        this.getReflectionHints(field.getDeclaringClass().getName()).getFields().add(field.getName());
        return this;
    }

    public RuntimeNativeMetadata registerConstructor(Constructor<?> constructor, ExecutableMode mode) {
        this.getReflectionHints(constructor.getDeclaringClass().getName()).getConstructors().add(new ExecutableHint("<init>", constructor.getParameterTypes(), mode));
        return this;
    }

    public RuntimeNativeMetadata registerMethod(Method method, ExecutableMode mode) {
        this.getReflectionHints(method.getDeclaringClass().getName()).getMethods().add(new ExecutableHint(method.getName(), method.getParameterTypes(), mode));
        return this;
    }

    public RuntimeNativeMetadata registerAllDeclaredMethod(Class<?> clazz, ExecutableMode mode) {
        Method[] declaredMethods;
        for (Method declaredMethod : declaredMethods = ReflectUtil.getDeclaredMethods(clazz)) {
            this.registerMethod(declaredMethod, mode);
        }
        return this;
    }

    public RuntimeNativeMetadata registerDefaultConstructor(Class<?> clazz) {
        if (ClassUtil.loadClass((String)clazz.getName()) != null && this.hasDefaultConstructor(clazz)) {
            this.getReflectionHints(clazz.getName()).getConstructors().add(new ExecutableHint("<init>", null, ExecutableMode.INVOKE));
        }
        return this;
    }

    public RuntimeNativeMetadata registerDefaultConstructor(String className) {
        Class clazz = ClassUtil.loadClass((String)className);
        if (clazz != null && this.hasDefaultConstructor(clazz)) {
            return this.registerDefaultConstructor(clazz);
        }
        return this;
    }

    public RuntimeNativeMetadata registerResourceInclude(String pattern) {
        return this.registerResourceInclude(pattern, null);
    }

    public RuntimeNativeMetadata registerResourceInclude(String pattern, String reachableType) {
        ResourceHint resourceHint = new ResourceHint();
        resourceHint.setReachableType(reachableType);
        resourceHint.setPattern(pattern);
        this.includes.add(resourceHint);
        return this;
    }

    public RuntimeNativeMetadata registerResourceExclude(String pattern) {
        return this.registerResourceExclude(pattern, null);
    }

    public RuntimeNativeMetadata registerResourceExclude(String pattern, String reachableType) {
        ResourceHint resourceHint = new ResourceHint();
        resourceHint.setReachableType(reachableType);
        resourceHint.setPattern(pattern);
        this.excludes.add(resourceHint);
        return this;
    }

    public RuntimeNativeMetadata registerSerialization(Package basePackage) {
        String dir = basePackage.getName().replace('.', '/');
        ScanUtil.scan((ClassLoader)AppClassLoader.global(), (String)dir, n -> n.endsWith(".class")).stream().forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            className = className.replace("/", ".");
            Class clz = ClassUtil.loadClass((ClassLoader)AppClassLoader.global(), (String)className);
            if (clz != null) {
                this.registerSerializationDo(clz.getName(), null);
            }
        });
        return this;
    }

    public RuntimeNativeMetadata registerSerialization(Class<?> type) {
        return this.registerSerialization(type, null);
    }

    public RuntimeNativeMetadata registerSerialization(String name) {
        this.registerSerializationDo(name, null);
        return this;
    }

    public RuntimeNativeMetadata registerSerialization(Class<?> type, String reachableType) {
        this.registerSerializationDo(type.getName(), reachableType);
        return this;
    }

    public RuntimeNativeMetadata registerLambdaSerialization(Class<?> type) {
        this.registerLambdaSerializationDo(ReflectUtil.getClassName(type), null, null);
        return this;
    }

    public String toReflectionJson() {
        if (this.reflection.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions).asArray();
        for (ReflectionHints hint : this.reflection.values()) {
            List introspect;
            List collect;
            List invoke;
            ONode item = oNode.addNew();
            item.set("name", (Object)hint.getName());
            if (Utils.isNotEmpty((String)hint.getReachableType())) {
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
            if (!(invoke = (collect = Stream.concat(hint.getConstructors().stream(), hint.getMethods().stream()).collect(Collectors.toList())).stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INVOKE)).collect(Collectors.toList())).isEmpty()) {
                ONode methods = item.getOrNew("methods").asArray();
                for (ExecutableHint executableHint : invoke) {
                    methods.addNew().set("name", (Object)executableHint.getName()).getOrNew("parameterTypes").asArray().addAll(executableHint.getParameterTypes());
                }
            }
            if (!(introspect = collect.stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INTROSPECT)).collect(Collectors.toList())).isEmpty()) {
                ONode queriedMethods = item.getOrNew("queriedMethods").asArray();
                for (ExecutableHint executableHint : introspect) {
                    queriedMethods.addNew().set("name", (Object)executableHint.getName()).getOrNew("parameterTypes").asArray().addAll(executableHint.getParameterTypes());
                }
            }
            if (!hint.getFields().isEmpty()) {
                ONode on = item.getOrNew("fields").asArray();
                if (!hint.getFields().isEmpty()) {
                    for (String field : hint.getFields()) {
                        on.addNew().set("name", (Object)field);
                    }
                }
            }
            this.handleCategories(item, hint.getMemberCategories());
        }
        return oNode.toJson();
    }

    public String toResourcesJson() {
        ONode item;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions);
        ONode resources = oNode.getOrNew("resources");
        if (!this.includes.isEmpty()) {
            ONode includesNode = resources.getOrNew("includes").asArray();
            for (ResourceHint hint : this.includes) {
                item = includesNode.addNew().set("pattern", (Object)hint.getPattern());
                if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
        }
        if (!this.excludes.isEmpty()) {
            ONode excludesNode = resources.getOrNew("excludes").asArray();
            for (ResourceHint hint : this.excludes) {
                item = excludesNode.addNew().set("pattern", (Object)hint.getPattern());
                if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
        }
        return oNode.toJson();
    }

    public String toSerializationJson() {
        if (this.serializations.isEmpty() && this.lambdaSerializations.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions);
        ONode types = oNode.getOrNew("types").asArray();
        for (SerializationHint hint : this.serializations.values()) {
            ONode item = types.addNew().set("name", (Object)hint.getName());
            if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
            item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
        }
        ONode lambdaCapturingTypes = oNode.getOrNew("lambdaCapturingTypes").asArray();
        for (SerializationHint hint : this.lambdaSerializations.values()) {
            ONode item = lambdaCapturingTypes.addNew().set("name", (Object)hint.getName());
            if (Utils.isNotEmpty((String)hint.getReachableType())) {
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
            if (!Utils.isNotEmpty((String)hint.getCustomTargetConstructorClass())) continue;
            item.set("customTargetConstructorClass", (Object)hint.getCustomTargetConstructorClass());
        }
        return oNode.toJson();
    }

    public String toJdkProxyJson() {
        if (this.jdkProxys.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions).asArray();
        for (JdkProxyHint hint : this.jdkProxys.values()) {
            if (Utils.isEmpty(hint.getInterfaces())) continue;
            ONode item = oNode.addNew();
            item.set("interfaces", hint.getInterfaces());
            if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
            item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
        }
        return oNode.toJson();
    }

    public Map<String, ReflectionHints> getReflection() {
        return this.reflection;
    }

    public Set<String> getArgs() {
        return this.args;
    }

    public List<ResourceHint> getIncludes() {
        return this.includes;
    }

    public List<ResourceHint> getExcludes() {
        return this.excludes;
    }

    public Map<String, SerializationHint> getSerializations() {
        return this.serializations;
    }

    public Map<String, SerializationHint> getLambdaSerializations() {
        return this.lambdaSerializations;
    }

    public Map<String, JdkProxyHint> getJdkProxys() {
        return this.jdkProxys;
    }

    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public void setApplicationClassName(String applicationClassName) {
        this.applicationClassName = applicationClassName;
    }

    private void handleCategories(ONode attributes, Set<MemberCategory> categories) {
        if (categories.isEmpty()) {
            return;
        }
        for (MemberCategory category : categories) {
            switch (category) {
                case PUBLIC_FIELDS: {
                    attributes.set("allPublicFields", (Object)true);
                    break;
                }
                case DECLARED_FIELDS: {
                    attributes.set("allDeclaredFields", (Object)true);
                    break;
                }
                case INTROSPECT_PUBLIC_CONSTRUCTORS: {
                    attributes.set("queryAllPublicConstructors", (Object)true);
                    break;
                }
                case INTROSPECT_DECLARED_CONSTRUCTORS: {
                    attributes.set("queryAllDeclaredConstructors", (Object)true);
                    break;
                }
                case INVOKE_PUBLIC_CONSTRUCTORS: {
                    attributes.set("allPublicConstructors", (Object)true);
                    break;
                }
                case INVOKE_DECLARED_CONSTRUCTORS: {
                    attributes.set("allDeclaredConstructors", (Object)true);
                    break;
                }
                case INTROSPECT_PUBLIC_METHODS: {
                    attributes.set("queryAllPublicMethods", (Object)true);
                    break;
                }
                case INTROSPECT_DECLARED_METHODS: {
                    attributes.set("queryAllDeclaredMethods", (Object)true);
                    break;
                }
                case INVOKE_PUBLIC_METHODS: {
                    attributes.set("allPublicMethods", (Object)true);
                    break;
                }
                case INVOKE_DECLARED_METHODS: {
                    attributes.set("allDeclaredMethods", (Object)true);
                    break;
                }
                case PUBLIC_CLASSES: {
                    attributes.set("allPublicClasses", (Object)true);
                    break;
                }
                case DECLARED_CLASSES: {
                    attributes.set("allDeclaredClasses", (Object)true);
                }
            }
        }
    }

    private void registerSerializationDo(String typeName, String reachableType) {
        if (!this.serializations.containsKey(typeName)) {
            SerializationHint serializationHint = new SerializationHint();
            serializationHint.setName(typeName);
            serializationHint.setReachableType(reachableType);
            this.serializations.put(typeName, serializationHint);
        }
    }

    private void registerLambdaSerializationDo(String name, String customTargetConstructorClass, String reachableType) {
        if (!this.lambdaSerializations.containsKey(name)) {
            SerializationHint serializationHint = new SerializationHint();
            serializationHint.setName(name);
            serializationHint.setCustomTargetConstructorClass(customTargetConstructorClass);
            serializationHint.setReachableType(reachableType);
            this.lambdaSerializations.put(name, serializationHint);
        }
    }

    private boolean hasDefaultConstructor(Class<?> clazz) {
        if (clazz.isInterface() || clazz.isEnum()) {
            return false;
        }
        return Arrays.stream(clazz.getDeclaredConstructors()).anyMatch(e -> e.getParameterCount() == 0);
    }

    private ReflectionHints getReflectionHints(String className) {
        return this.reflection.computeIfAbsent(className, k -> {
            ReflectionHints hints = new ReflectionHints();
            hints.setName(className);
            return hints;
        });
    }
}

