/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.noear.solon.aot.RuntimeNativeMetadata;
import org.noear.solon.aot.hint.ExecutableMode;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class NativeMetadataUtils {
    public static void registerMethodAndParamAndReturnType(RuntimeNativeMetadata metadata, MethodWrap methodWrap) {
        ParamWrap[] paramWraps;
        metadata.registerMethod(methodWrap.getMethod(), ExecutableMode.INVOKE);
        for (ParamWrap paramWrap : paramWraps = methodWrap.getParamWraps()) {
            Class paramType = paramWrap.getType();
            metadata.registerReflection(paramType, MemberCategory.PUBLIC_FIELDS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
            if (!paramType.getName().startsWith("java.") && Serializable.class.isAssignableFrom(paramType)) {
                metadata.registerSerialization(paramType);
            }
            ParameterizedType genericType = paramWrap.getGenericType();
            NativeMetadataUtils.processGenericType(metadata, genericType);
        }
        Class returnType = methodWrap.getReturnType();
        metadata.registerReflection(returnType, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
        if (!returnType.getName().startsWith("java.") && Serializable.class.isAssignableFrom(returnType)) {
            metadata.registerSerialization(returnType);
        }
        ParameterizedType genericReturnType = methodWrap.getGenericReturnType();
        NativeMetadataUtils.processGenericType(metadata, genericReturnType);
    }

    private static void processGenericType(RuntimeNativeMetadata metadata, Type genericType) {
        Map genericInfo = GenericUtil.getGenericInfo((Type)genericType);
        for (Map.Entry entry : genericInfo.entrySet()) {
            if (((Type)entry.getValue()).getTypeName().startsWith("java.")) continue;
            metadata.registerReflection(((Type)entry.getValue()).getTypeName(), MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS);
        }
    }
}

