/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.math.BigDecimal;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectPatternEncoder;

public class _NumberPatternEncoder
implements ObjectPatternEncoder<Number> {
    @Override
    public boolean canEncode(Object value) {
        return value instanceof Number;
    }

    @Override
    public ONode encode(EncodeContext ctx, Number value, ONode target) {
        if (ctx.getAttr() != null) {
            if (ctx.getAttr().hasFeature(Feature.Write_NumbersAsString)) {
                return target.setValue(value.toString());
            }
            if (ctx.getAttr().hasFeature(Feature.Write_DoubleAsString) && value instanceof Double) {
                return target.setValue(value.toString());
            }
            if (ctx.getAttr().hasFeature(Feature.Write_LongAsString) && value instanceof Long) {
                return target.setValue(value.toString());
            }
            if (ctx.getAttr().hasFeature(Feature.Write_BigDecimalAsPlain) && value instanceof BigDecimal) {
                return target.setValue(((BigDecimal)value).toPlainString());
            }
        }
        return target.setValue(value);
    }
}

