/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.util.Asserts;

public class OffsetTimeEncoder
implements ObjectEncoder<OffsetTime> {
    @Override
    public ONode encode(EncodeContext ctx, OffsetTime value, ONode target) {
        if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat())) {
            DateTimeFormatter f = DateTimeFormatter.ofPattern(ctx.getAttr().getFormat());
            return target.setValue(f.format(value));
        }
        Instant it = value.atDate(LocalDate.of(1970, 1, 1)).toInstant();
        return target.setValue(Date.from(it));
    }
}

