/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.util.Asserts;

public class LocalTimeEncoder
implements ObjectEncoder<LocalTime> {
    @Override
    public ONode encode(EncodeContext ctx, LocalTime value, ONode target) {
        if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat())) {
            DateTimeFormatter f = DateTimeFormatter.ofPattern(ctx.getAttr().getFormat());
            return target.setValue(f.format(value));
        }
        Instant it = value.atDate(LocalDate.of(1970, 1, 1)).atZone(Options.DEF_TIME_ZONE.toZoneId()).toInstant();
        return target.setValue(new Date(it.getEpochSecond() * 1000L));
    }
}

