/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.util.Asserts;

public class LocalDateEncoder
implements ObjectEncoder<LocalDate> {
    @Override
    public ONode encode(EncodeContext ctx, LocalDate value, ONode target) {
        if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat())) {
            DateTimeFormatter fr = DateTimeFormatter.ofPattern(ctx.getAttr().getFormat());
            if (ctx.getAttr().getZoneId() != null) {
                fr.withZone(ctx.getAttr().getZoneId());
            }
            return target.setValue(fr.format(value));
        }
        Instant instant = value.atTime(LocalTime.MIN).atZone(Options.DEF_TIME_ZONE.toZoneId()).toInstant();
        return target.setValue(new Date(instant.getEpochSecond() * 1000L));
    }
}

