/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec;

import java.lang.reflect.Type;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.Feature;
import org.noear.snack4.Options;
import org.noear.snack4.annotation.ONodeAttrHolder;

public class DecodeContext<T> {
    private final Options options;
    private final ONodeAttrHolder attr;
    private final T target;
    private final TypeEggg typeEggg;

    public DecodeContext(Options options, ONodeAttrHolder attr, T target, TypeEggg typeEggg) {
        this.options = options;
        this.target = target;
        this.typeEggg = typeEggg;
        if ((attr == null || attr.isEmpty()) && !typeEggg.isJdkType()) {
            attr = (ONodeAttrHolder)typeEggg.getClassEggg().getDigest();
        }
        this.attr = attr;
    }

    public Options getOptions() {
        return this.options;
    }

    public ONodeAttrHolder getAttr() {
        return this.attr;
    }

    public T getTarget() {
        return this.target;
    }

    public TypeEggg getTypeEggg() {
        return this.typeEggg;
    }

    public Class<?> getType() {
        return this.typeEggg.getType();
    }

    public Type getGenericType() {
        return this.typeEggg.getGenericType();
    }

    public boolean hasFeature(Feature feature) {
        if (this.attr != null && !this.attr.isEmpty() && this.attr.hasFeature(feature)) {
            return true;
        }
        return this.options.hasFeature(feature);
    }
}

