/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.noear.snack4.codec.KeyValueList;
import org.noear.snack4.codec.ObjectCreator;
import org.noear.snack4.codec.ObjectDecoder;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.codec.ObjectPatternCreator;
import org.noear.snack4.codec.ObjectPatternDecoder;
import org.noear.snack4.codec.ObjectPatternEncoder;
import org.noear.snack4.codec.create._ThrowablePatternCreator;
import org.noear.snack4.codec.decode.BigDecimalDecoder;
import org.noear.snack4.codec.decode.BigIntegerDecoder;
import org.noear.snack4.codec.decode.ClassDecoder;
import org.noear.snack4.codec.decode.DateDecoder;
import org.noear.snack4.codec.decode.DoubleAdderDecoder;
import org.noear.snack4.codec.decode.DurationDecoder;
import org.noear.snack4.codec.decode.FileDecoder;
import org.noear.snack4.codec.decode.InetSocketAddressDecoder;
import org.noear.snack4.codec.decode.LocalDateDecoder;
import org.noear.snack4.codec.decode.LocalDateTimeDecoder;
import org.noear.snack4.codec.decode.LocalTimeDecoder;
import org.noear.snack4.codec.decode.LongAdderDecoder;
import org.noear.snack4.codec.decode.OffsetDateTimeDecoder;
import org.noear.snack4.codec.decode.OffsetTimeDecoder;
import org.noear.snack4.codec.decode.SimpleDateFormatDecoder;
import org.noear.snack4.codec.decode.StackTraceElementDecoder;
import org.noear.snack4.codec.decode.URLDecoder;
import org.noear.snack4.codec.decode.ZonedDateTimeDecoder;
import org.noear.snack4.codec.decode._ArrayPatternDecoder;
import org.noear.snack4.codec.decode._CharsetPatternDecoder;
import org.noear.snack4.codec.decode._CurrencytPatternDecoder;
import org.noear.snack4.codec.decode._EnumPatternDecoder;
import org.noear.snack4.codec.decode._PropertiesPatternDecoder;
import org.noear.snack4.codec.decode._TimeZonePatternDecoder;
import org.noear.snack4.codec.encode.BooleanEncoder;
import org.noear.snack4.codec.encode.InetSocketAddressEncoder;
import org.noear.snack4.codec.encode.KeyValueListEncoder;
import org.noear.snack4.codec.encode.LocalDateEncoder;
import org.noear.snack4.codec.encode.LocalDateTimeEncoder;
import org.noear.snack4.codec.encode.LocalTimeEncoder;
import org.noear.snack4.codec.encode.OffsetDateTimeEncoder;
import org.noear.snack4.codec.encode.OffsetTimeEncoder;
import org.noear.snack4.codec.encode.SimpleDateFormatEncoder;
import org.noear.snack4.codec.encode.StackTraceElementEncoder;
import org.noear.snack4.codec.encode.StringEncoder;
import org.noear.snack4.codec.encode.ZonedDateTimeEncoder;
import org.noear.snack4.codec.encode._CalendarPatternEncoder;
import org.noear.snack4.codec.encode._CharsetPatternEncoder;
import org.noear.snack4.codec.encode._ClobPatternEncoder;
import org.noear.snack4.codec.encode._CurrencyPatternEncoder;
import org.noear.snack4.codec.encode._DatePatternEncoder;
import org.noear.snack4.codec.encode._EnumPatternEncoder;
import org.noear.snack4.codec.encode._NumberPatternEncoder;
import org.noear.snack4.codec.encode._PropertiesPatternEncoder;
import org.noear.snack4.codec.encode._TimeZonePatternEncoder;

public class CodecLib {
    private static CodecLib DEFAULT = new CodecLib(null).loadDefault();
    private final Map<Class<?>, ObjectCreator<?>> creators = new HashMap();
    private final List<ObjectPatternCreator<?>> patternCreators = new ArrayList();
    private final Map<Class<?>, ObjectDecoder<?>> decoders = new HashMap();
    private final List<ObjectPatternDecoder<?>> patternDecoders = new ArrayList();
    private final Map<Class<?>, ObjectEncoder<?>> encoders = new HashMap();
    private final List<ObjectPatternEncoder<?>> patternEncoders = new ArrayList();
    private final CodecLib parent;

    private CodecLib(CodecLib parent) {
        this.parent = parent;
    }

    public static CodecLib newInstance() {
        return new CodecLib(DEFAULT);
    }

    public <T> void addCreator(Class<T> type, ObjectCreator<T> creator) {
        this.creators.put(type, creator);
    }

    public void addCreator(ObjectPatternCreator creator) {
        this.patternCreators.add(creator);
    }

    public void addDecoder(ObjectPatternDecoder decoder) {
        this.patternDecoders.add(decoder);
    }

    public <T> void addDecoder(Class<T> type, ObjectDecoder<T> decoder) {
        if (decoder instanceof ObjectPatternDecoder) {
            this.patternDecoders.add((ObjectPatternDecoder)decoder);
        }
        this.decoders.put(type, decoder);
    }

    public void addEncoder(ObjectPatternEncoder encoder) {
        this.patternEncoders.add(encoder);
    }

    public <T> void addEncoder(Class<T> type, ObjectEncoder<T> encoder) {
        if (encoder instanceof ObjectPatternEncoder) {
            this.patternEncoders.add((ObjectPatternEncoder)encoder);
        }
        this.encoders.put(type, encoder);
    }

    public ObjectDecoder getDecoder(Class<?> clazz) {
        ObjectDecoder<?> tmp = this.decoders.get(clazz);
        if (tmp == null) {
            for (ObjectPatternDecoder<?> decoder1 : this.patternDecoders) {
                if (!decoder1.canDecode(clazz)) continue;
                return decoder1;
            }
            if (this.parent != null) {
                return this.parent.getDecoder(clazz);
            }
        }
        return tmp;
    }

    public ObjectCreator getCreator(Class<?> clazz) {
        ObjectCreator<?> tmp = this.creators.get(clazz);
        if (tmp == null) {
            for (ObjectPatternCreator<?> creator1 : this.patternCreators) {
                if (!creator1.calCreate(clazz)) continue;
                return creator1;
            }
            if (this.parent != null) {
                return this.parent.getCreator(clazz);
            }
        }
        return tmp;
    }

    public ObjectEncoder getEncoder(Object value) {
        ObjectEncoder<?> encoder = this.encoders.get(value.getClass());
        if (encoder == null) {
            for (ObjectPatternEncoder<?> encoder1 : this.patternEncoders) {
                if (!encoder1.canEncode(value)) continue;
                return encoder1;
            }
            if (this.parent != null) {
                return this.parent.getEncoder(value);
            }
        }
        return encoder;
    }

    private void loadDefaultCreators() {
        this.addCreator(new _ThrowablePatternCreator());
        this.addCreator(HashMap.class, (opts, node, clazz) -> new HashMap());
        this.addCreator(LinkedHashMap.class, (opts, node, clazz) -> new LinkedHashMap());
        this.addCreator(Map.class, (opts, node, clazz) -> new LinkedHashMap());
        this.addCreator(ArrayList.class, (opts, node, clazz) -> new ArrayList());
        this.addCreator(Collection.class, (opts, node, clazz) -> new ArrayList());
        this.addCreator(List.class, (opts, node, clazz) -> new ArrayList());
        this.addCreator(Set.class, (opts, node, clazz) -> new HashSet());
        this.addCreator(HashSet.class, (opts, node, clazz) -> new HashSet());
    }

    private void loadDefaultDecoders() {
        this.addDecoder(new _ArrayPatternDecoder());
        this.addDecoder(new _EnumPatternDecoder());
        this.addDecoder(new _PropertiesPatternDecoder());
        this.addDecoder(Charset.class, new _CharsetPatternDecoder());
        this.addDecoder(TimeZone.class, new _TimeZonePatternDecoder());
        this.addDecoder(Currency.class, new _CurrencytPatternDecoder());
        this.addDecoder(StackTraceElement.class, new StackTraceElementDecoder());
        this.addDecoder(InetSocketAddress.class, new InetSocketAddressDecoder());
        this.addDecoder(SimpleDateFormat.class, new SimpleDateFormatDecoder());
        this.addDecoder(File.class, new FileDecoder());
        this.addDecoder(Class.class, new ClassDecoder());
        this.addDecoder(Duration.class, new DurationDecoder());
        this.addDecoder(URL.class, new URLDecoder());
        this.addDecoder(Date.class, new DateDecoder());
        this.addDecoder(LongAdder.class, new LongAdderDecoder());
        this.addDecoder(DoubleAdder.class, new DoubleAdderDecoder());
        this.addDecoder(LocalTime.class, new LocalTimeDecoder());
        this.addDecoder(LocalDateTime.class, new LocalDateTimeDecoder());
        this.addDecoder(LocalDate.class, new LocalDateDecoder());
        this.addDecoder(OffsetDateTime.class, new OffsetDateTimeDecoder());
        this.addDecoder(OffsetTime.class, new OffsetTimeDecoder());
        this.addDecoder(ZonedDateTime.class, new ZonedDateTimeDecoder());
        this.addDecoder(BigDecimal.class, new BigDecimalDecoder());
        this.addDecoder(BigInteger.class, new BigIntegerDecoder());
        this.addDecoder(URI.class, (c, o) -> URI.create(o.getString()));
        this.addDecoder(UUID.class, (c, o) -> UUID.fromString(o.getString()));
        this.addDecoder(java.sql.Date.class, (c, o) -> new java.sql.Date(o.getLong()));
        this.addDecoder(Time.class, (c, o) -> new Time(o.getLong()));
        this.addDecoder(Timestamp.class, (c, o) -> new Timestamp(o.getLong()));
        this.addDecoder(String.class, (c, o) -> o.getString());
        this.addDecoder(Boolean.class, (c, o) -> o.getBoolean(null));
        this.addDecoder(Boolean.TYPE, (c, o) -> o.getBoolean(false));
        this.addDecoder(Double.class, (c, o) -> o.getDouble(null));
        this.addDecoder(Double.TYPE, (c, o) -> o.getDouble(0.0));
        this.addDecoder(Float.class, (c, o) -> o.getFloat(null));
        this.addDecoder(Float.TYPE, (c, o) -> o.getFloat(Float.valueOf(0.0f)));
        this.addDecoder(Long.class, (c, o) -> o.getLong(null));
        this.addDecoder(Long.TYPE, (c, o) -> o.getLong(0L));
        this.addDecoder(Integer.class, (c, o) -> o.getInt(null));
        this.addDecoder(Integer.TYPE, (c, o) -> o.getInt(0));
        this.addDecoder(Short.class, (c, o) -> o.getShort(null));
        this.addDecoder(Short.TYPE, (c, o) -> o.getShort((short)0));
        this.addDecoder(Byte.class, (c, o) -> o.getByte(null));
        this.addDecoder(Byte.TYPE, (c, o) -> o.getByte((byte)0));
    }

    private void loadDefaultEncoders() {
        this.addEncoder(new _EnumPatternEncoder());
        this.addEncoder(new _PropertiesPatternEncoder());
        this.addEncoder(Charset.class, new _CharsetPatternEncoder());
        this.addEncoder(Date.class, new _DatePatternEncoder());
        this.addEncoder(Number.class, new _NumberPatternEncoder());
        this.addEncoder(Calendar.class, new _CalendarPatternEncoder());
        this.addEncoder(Clob.class, new _ClobPatternEncoder());
        this.addEncoder(TimeZone.class, new _TimeZonePatternEncoder());
        this.addEncoder(Currency.class, new _CurrencyPatternEncoder());
        this.addEncoder(KeyValueList.class, new KeyValueListEncoder());
        this.addEncoder(StackTraceElement.class, new StackTraceElementEncoder());
        this.addEncoder(InetSocketAddress.class, new InetSocketAddressEncoder());
        this.addEncoder(SimpleDateFormat.class, new SimpleDateFormatEncoder());
        this.addEncoder(String.class, new StringEncoder());
        this.addEncoder(LocalDateTime.class, new LocalDateTimeEncoder());
        this.addEncoder(LocalDate.class, new LocalDateEncoder());
        this.addEncoder(LocalTime.class, new LocalTimeEncoder());
        this.addEncoder(OffsetDateTime.class, new OffsetDateTimeEncoder());
        this.addEncoder(OffsetTime.class, new OffsetTimeEncoder());
        this.addEncoder(ZonedDateTime.class, new ZonedDateTimeEncoder());
        this.addEncoder(Boolean.class, new BooleanEncoder());
        this.addEncoder(Boolean.TYPE, new BooleanEncoder());
        this.addEncoder(Duration.class, (c, v, t) -> t.setValue(v.toString()));
        this.addEncoder(File.class, (c, v, t) -> t.setValue(v.getPath()));
        this.addEncoder(LongAdder.class, (c, v, t) -> t.setValue(v.longValue()));
        this.addEncoder(DoubleAdder.class, (c, v, t) -> t.setValue(v.doubleValue()));
        this.addEncoder(URL.class, (c, v, t) -> t.setValue(v.toString()));
        this.addEncoder(URI.class, (c, v, t) -> t.setValue(v.toString()));
        this.addEncoder(Class.class, (c, v, t) -> t.setValue(v.getName()));
        this.addEncoder(UUID.class, (ctx, value, target) -> target.setValue(value.toString()));
    }

    private CodecLib loadDefault() {
        this.loadDefaultCreators();
        this.loadDefaultDecoders();
        this.loadDefaultEncoders();
        return this;
    }
}

