/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Property;
import org.noear.eggg.PropertyEggg;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.codec.CodecException;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.codec.util.EgggUtil;
import org.noear.snack4.util.Asserts;

public class BeanEncoder {
    private final Object source0;
    private final Options opts;
    private final Map<Object, Object> visited;
    private final boolean Write_Nulls;
    private final boolean onlyUseGetter;
    private final boolean allowUseGetter;

    public static ONode encode(Object value) {
        return BeanEncoder.encode(value, null);
    }

    public static ONode encode(Object value, Options opts) {
        if (value == null) {
            return new ONode(opts, null);
        }
        if (value instanceof ONode) {
            return (ONode)value;
        }
        return new BeanEncoder(value, opts).encode();
    }

    private BeanEncoder(Object value, Options opts) {
        this.source0 = value;
        this.opts = opts == null ? Options.DEF_OPTIONS : opts;
        this.visited = new IdentityHashMap<Object, Object>();
        this.Write_Nulls = this.opts.hasFeature(Feature.Write_Nulls);
        this.onlyUseGetter = this.opts.hasFeature(Feature.Read_OnlyUseGetter);
        this.allowUseGetter = this.onlyUseGetter || this.opts.hasFeature(Feature.Read_AllowUseGetter);
    }

    public ONode encode() {
        try {
            ONode oNode = this.encodeValueToNode(this.source0, null);
            if (oNode.isObject() && this.opts.hasFeature(Feature.Write_NotRootClassName)) {
                oNode.remove(this.opts.getTypePropertyName());
            }
            return oNode;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CodecException("Failed to encode bean to ONode", e);
        }
    }

    private ONode encodeValueToNode(Object value, ONodeAttrHolder attr) throws Throwable {
        if (value == null) {
            if (this.Write_Nulls) {
                return new ONode(this.opts, null);
            }
            return null;
        }
        if (value instanceof ONode) {
            return (ONode)value;
        }
        if (value instanceof ObjectEncoder) {
            return ((ObjectEncoder)value).encode(new EncodeContext(this.opts, attr, value), value, new ONode(this.opts));
        }
        ObjectEncoder<?> codec = this.opts.getEncoder(value);
        if (codec != null) {
            return codec.encode(new EncodeContext(this.opts, attr, value), value, new ONode(this.opts));
        }
        if (value instanceof Collection) {
            return this.encodeCollectionToNode((Collection)value);
        }
        if (value instanceof Map) {
            return this.encodeMapToNode((Map)value);
        }
        if (value.getClass().isArray()) {
            return this.encodeArrayToNode(value);
        }
        return this.encodeBeanToNode(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ONode encodeBeanToNode(Object bean) throws Throwable {
        if (this.visited.containsKey(bean)) {
            return null;
        }
        this.visited.put(bean, null);
        ONode tmp = new ONode(this.opts).asObject();
        try {
            if (this.isWriteClassName(this.opts, bean)) {
                tmp.set(this.opts.getTypePropertyName(), bean.getClass().getName());
            }
            ClassEggg classEggg = EgggUtil.getTypeEggg(bean.getClass()).getClassEggg();
            for (PropertyEggg pw : classEggg.getPropertyEgggs()) {
                ONode propertyNode;
                Object property = this.onlyUseGetter ? pw.getGetterEggg() : (this.allowUseGetter && pw.getGetterEggg() != null ? pw.getGetterEggg() : pw.getFieldEggg());
                if (property == null) continue;
                ONodeAttrHolder attr = (ONodeAttrHolder)property.getDigest();
                if (property.isTransient() || !attr.isEncode() || (propertyNode = this.encodeBeanPropertyToNode(bean, (Property)property)) == null) continue;
                if (attr.isFlat()) {
                    if (!propertyNode.isObject()) continue;
                    tmp.setAll(propertyNode.getObject());
                    continue;
                }
                tmp.set(property.getAlias(), propertyNode);
            }
        }
        finally {
            this.visited.remove(bean);
        }
        return tmp;
    }

    private ONode encodeBeanPropertyToNode(Object bean, Property property) throws Throwable {
        Object propValue = property.getValue(bean);
        ONode propNode = null;
        ONodeAttrHolder attr = (ONodeAttrHolder)property.getDigest();
        if (attr.getEncoder() != null) {
            propNode = attr.getEncoder().encode(new EncodeContext(this.opts, attr, propValue), propValue, new ONode(this.opts));
        } else {
            if (propValue == null) {
                TypeEggg ptw = property.getTypeEggg();
                if (ptw.getType() == List.class) {
                    if (this.opts.hasFeature(Feature.Write_NullListAsEmpty) || attr.hasFeature(Feature.Write_NullListAsEmpty)) {
                        propValue = new ArrayList();
                    }
                } else if (ptw.isString()) {
                    if (this.opts.hasFeature(Feature.Write_NullStringAsEmpty) || attr.hasFeature(Feature.Write_NullStringAsEmpty)) {
                        propValue = "";
                    }
                } else if (ptw.isBoolean()) {
                    if (this.opts.hasFeature(Feature.Write_NullBooleanAsFalse) || attr.hasFeature(Feature.Write_NullBooleanAsFalse)) {
                        propValue = false;
                    }
                } else if (ptw.isNumber() && (this.opts.hasFeature(Feature.Write_NullNumberAsZero) || attr.hasFeature(Feature.Write_NullNumberAsZero))) {
                    propValue = ptw.getType() == Long.class ? (Number)0L : (Number)(ptw.getType() == Double.class ? (Number)0.0 : (Number)(ptw.getType() == Float.class ? (Number)Float.valueOf(0.0f) : (Number)0));
                }
                if (propValue == null && !this.Write_Nulls && !attr.hasFeature(Feature.Write_Nulls)) {
                    return null;
                }
            }
            if (propValue instanceof Date && Asserts.isNotEmpty(attr.getFormat())) {
                String dateStr = attr.formatDate((Date)propValue);
                propNode = new ONode(this.opts, dateStr);
            }
            if (propNode == null) {
                propNode = this.encodeValueToNode(propValue, attr);
            }
        }
        return propNode;
    }

    private ONode encodeArrayToNode(Object array) throws Throwable {
        ONode tmp = new ONode(this.opts).asArray();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            tmp.add(this.encodeValueToNode(Array.get(array, i), null));
        }
        return tmp;
    }

    private ONode encodeCollectionToNode(Collection<?> collection) throws Throwable {
        ONode tmp = new ONode(this.opts).asArray();
        for (Object item : collection) {
            tmp.add(this.encodeValueToNode(item, null));
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ONode encodeMapToNode(Map<?, ?> map) throws Throwable {
        if (this.visited.containsKey(map)) {
            return null;
        }
        this.visited.put(map, null);
        try {
            ONode tmp = new ONode(this.opts).asObject();
            if (this.isWriteClassName(this.opts, map)) {
                tmp.set(this.opts.getTypePropertyName(), map.getClass().getName());
            }
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                ONode valueNode = this.encodeValueToNode(entry.getValue(), null);
                if (valueNode == null) continue;
                tmp.set(String.valueOf(entry.getKey()), valueNode);
            }
            ONode oNode = tmp;
            return oNode;
        }
        finally {
            this.visited.remove(map);
        }
    }

    private boolean isWriteClassName(Options opts, Object obj) {
        if (obj == null) {
            return false;
        }
        if (!opts.hasFeature(Feature.Write_ClassName)) {
            return false;
        }
        return !(obj instanceof Map) || !opts.hasFeature(Feature.Write_NotMapClassName);
    }
}

