/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.annotation;

import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.noear.snack4.Feature;
import org.noear.snack4.annotation.ONodeAttr;
import org.noear.snack4.codec.ObjectDecoder;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.codec.util.ClassUtil;
import org.noear.snack4.codec.util.DateUtil;
import org.noear.snack4.util.Asserts;

public class ONodeAttrHolder {
    private String alias;
    private String title;
    private String description;
    private String format;
    private ZoneId zoneId;
    private TimeZone timezone;
    private boolean flat;
    private boolean required;
    private final boolean empty;
    private boolean encode = true;
    private boolean decode = true;
    private ObjectEncoder encoder;
    private ObjectDecoder decoder;
    private long featuresValue;

    public ONodeAttrHolder(String alias, String title, String description, boolean required) {
        this.alias = alias;
        this.title = title;
        this.description = description;
        this.required = required;
        this.empty = true;
    }

    public ONodeAttrHolder(ONodeAttr attrAnno, String realName) {
        if (attrAnno != null) {
            this.alias = attrAnno.name();
            this.title = attrAnno.title();
            this.description = attrAnno.description();
            this.format = attrAnno.format();
            if (Asserts.isNotEmpty(attrAnno.timezone())) {
                this.zoneId = ZoneId.of(attrAnno.timezone());
                this.timezone = TimeZone.getTimeZone(this.zoneId);
            }
            this.flat = attrAnno.flat();
            this.required = attrAnno.required();
            if (attrAnno.ignore()) {
                this.encode = false;
                this.decode = false;
            } else {
                this.encode = attrAnno.encode();
                this.decode = attrAnno.decode();
            }
            if (!attrAnno.encoder().isInterface()) {
                this.encoder = ClassUtil.newInstance(attrAnno.encoder());
            }
            if (!attrAnno.decoder().isInterface()) {
                this.decoder = ClassUtil.newInstance(attrAnno.decoder());
            }
            this.featuresValue = Feature.addFeatures(0L, attrAnno.features());
            this.empty = false;
        } else {
            this.empty = true;
        }
        if (Asserts.isEmpty(this.alias)) {
            this.alias = realName;
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Deprecated
    public TimeZone getTimezone() {
        return this.timezone;
    }

    public String formatDate(Date value) {
        if (this.getZoneId() != null) {
            return DateUtil.format(value, this.getFormat(), this.getZoneId());
        }
        return DateUtil.format(value, this.getFormat());
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean hasFeature(Feature feature) {
        return Feature.hasFeature(this.featuresValue, feature);
    }

    public boolean isEncode() {
        return this.encode;
    }

    public boolean isDecode() {
        return this.decode;
    }

    public ObjectEncoder getEncoder() {
        return this.encoder;
    }

    public ObjectDecoder getDecoder() {
        return this.decoder;
    }
}

