/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.noear.snack4.DataType;
import org.noear.snack4.Feature;
import org.noear.snack4.Options;
import org.noear.snack4.SnackException;
import org.noear.snack4.codec.BeanDecoder;
import org.noear.snack4.codec.BeanEncoder;
import org.noear.snack4.codec.TypeRef;
import org.noear.snack4.codec.util.DateUtil;
import org.noear.snack4.json.JsonReader;
import org.noear.snack4.json.JsonWriter;
import org.noear.snack4.jsonpath.JsonPathProvider;
import org.noear.snack4.jsonpath.PathSource;
import org.noear.snack4.util.Asserts;

public final class ONode {
    private static JsonPathProvider jsonPathProvider = () -> "Requires 'snack4-jsonpath' dependency";
    private Object value;
    private transient DataType type;
    private transient Options options;
    public transient PathSource source;
    private transient String path;

    public ONode() {
        this(Options.DEF_OPTIONS);
    }

    public ONode(Object value) {
        this(Options.DEF_OPTIONS, value);
    }

    public ONode(Options opts) {
        this.type = DataType.Undefined;
        this.options = opts == null ? Options.DEF_OPTIONS : opts;
    }

    public ONode(Options opts, Object value) {
        this.value = value;
        this.type = DataType.resolveType(value);
        this.options = opts == null ? Options.DEF_OPTIONS : opts;
    }

    public DataType type() {
        return this.type;
    }

    public Options options() {
        return this.options;
    }

    public ONode options(Options opts) {
        this.options = opts;
        return this;
    }

    public boolean isUndefined() {
        return this.type == DataType.Undefined;
    }

    public boolean isNull() {
        return this.type == DataType.Null || this.isUndefined();
    }

    public boolean isEmpty() {
        return this.isNull() || this.isArray() && this.getArray().isEmpty() || this.isObject() && this.getObject().isEmpty() || this.isString() && this.getString().isEmpty();
    }

    public boolean isBoolean() {
        return this.type == DataType.Boolean;
    }

    public boolean isNumber() {
        return this.type == DataType.Number;
    }

    public boolean isString() {
        return this.type == DataType.String;
    }

    public boolean isNotEmptyString() {
        return this.isString() && ((String)this.getValueAs()).length() > 0;
    }

    public boolean isDate() {
        return this.type == DataType.Date;
    }

    public boolean isArray() {
        return this.type == DataType.Array;
    }

    public boolean isObject() {
        return this.type == DataType.Object;
    }

    public boolean isValue() {
        return DataType.isValue(this.type);
    }

    public Object getValue() {
        return this.value;
    }

    public <T> T getValueAs() {
        return (T)this.value;
    }

    public List<ONode> getArray() {
        this.asArray();
        return (List)this.value;
    }

    public List<ONode> getArrayUnsafe() {
        return (List)this.value;
    }

    public Map<String, ONode> getObject() {
        this.asObject();
        return (Map)this.value;
    }

    public Map<String, ONode> getObjectUnsafe() {
        return (Map)this.value;
    }

    public ONode asObject() {
        if (this.value == null) {
            this.value = this.options.createMap();
            this.type = DataType.Object;
        }
        return this;
    }

    public ONode asObject(Supplier<Map> factory) {
        if (this.value == null) {
            this.value = factory.get();
            this.type = DataType.Object;
        }
        return this;
    }

    public ONode asArray() {
        if (this.value == null) {
            this.value = this.options.createList();
            this.type = DataType.Array;
        }
        return this;
    }

    public ONode asArray(Supplier<List> factory) {
        if (this.value == null) {
            this.value = factory.get();
            this.type = DataType.Array;
        }
        return this;
    }

    public Boolean getBoolean() {
        return this.getBoolean(false);
    }

    public Boolean getBoolean(Boolean def) {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        if (this.isNumber()) {
            return this.getNumber().longValue() > 0L;
        }
        if (this.isString()) {
            String str = (String)this.getValueAs();
            if (str.length() > 0) {
                return Boolean.parseBoolean((String)this.value);
            }
            return false;
        }
        return def;
    }

    public Number getNumber() {
        return (Number)this.value;
    }

    public Number getNumber(Number def) {
        if (this.value == null) {
            return def;
        }
        return (Number)this.value;
    }

    public String getString() {
        if (this.isString()) {
            return (String)this.value;
        }
        if (this.isNumber()) {
            if (this.value instanceof BigDecimal && this.options.hasFeature(Feature.Write_BigDecimalAsPlain)) {
                return ((BigDecimal)this.value).toPlainString();
            }
            return this.value.toString();
        }
        if (this.isObject() || this.isArray()) {
            return this.toJson();
        }
        if (this.isNull()) {
            if (this.options.hasFeature(Feature.Write_NullStringAsEmpty)) {
                return "";
            }
            return null;
        }
        return String.valueOf(this.value);
    }

    public Date getDate() {
        if (this.isDate()) {
            return (Date)this.value;
        }
        if (this.isNumber()) {
            return new Date(this.getNumber().longValue());
        }
        if (this.isString()) {
            return DateUtil.parseTry(this.getString());
        }
        return null;
    }

    public Byte getByte() {
        return this.getByte((byte)0);
    }

    public Byte getByte(Byte def) {
        if (this.isNumber()) {
            return this.getNumber().byteValue();
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Byte.parseByte(this.getString());
        }
        return def;
    }

    public Short getShort() {
        return this.getShort((short)0);
    }

    public Short getShort(Short def) {
        if (this.isNumber()) {
            return this.getNumber().shortValue();
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Short.parseShort(this.getString());
        }
        return def;
    }

    public Integer getInt() {
        return this.getInt(0);
    }

    public Integer getInt(Integer def) {
        if (this.isNumber()) {
            return this.getNumber().intValue();
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Integer.parseInt(this.getString());
        }
        if (this.isBoolean()) {
            return this.getBoolean() != false ? 1 : 0;
        }
        return def;
    }

    public Long getLong() {
        return this.getLong(0L);
    }

    public Long getLong(Long def) {
        if (this.isNumber()) {
            return this.getNumber().longValue();
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Long.parseLong(this.getString());
        }
        if (this.isBoolean()) {
            return this.getBoolean() != false ? 1L : 0L;
        }
        if (this.isDate()) {
            return this.getDate().getTime();
        }
        return def;
    }

    public Float getFloat() {
        return this.getFloat(Float.valueOf(0.0f));
    }

    public Float getFloat(Float def) {
        if (this.isNumber()) {
            return Float.valueOf(this.getNumber().floatValue());
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Float.valueOf(Float.parseFloat(this.getString()));
        }
        if (this.isBoolean()) {
            return Float.valueOf(this.getBoolean() != false ? 1.0f : 0.0f);
        }
        return def;
    }

    public Double getDouble() {
        return this.getDouble(0.0);
    }

    public Double getDouble(Double def) {
        if (this.isNumber()) {
            return this.getNumber().doubleValue();
        }
        if (this.isEmpty()) {
            return def;
        }
        if (this.isString()) {
            return Double.parseDouble(this.getString());
        }
        if (this.isBoolean()) {
            return this.getBoolean() != false ? 1.0 : 0.0;
        }
        return def;
    }

    public ONode get(String key) {
        ONode tmp = this.getObject().get(key);
        if (tmp == null) {
            return new ONode(this.options);
        }
        return tmp;
    }

    public ONode getOrNew(String key) {
        return this.getObject().computeIfAbsent(key, k -> new ONode(this.options, null));
    }

    public ONode getOrNull(String key) {
        if (this.isObject()) {
            return this.getObjectUnsafe().get(key);
        }
        return null;
    }

    public ONode remove(String key) {
        if (this.isObject()) {
            return this.getObjectUnsafe().remove(key);
        }
        return null;
    }

    public ONode rename(String oldName, String newName) {
        ONode tmp = this.remove(oldName);
        if (tmp != null) {
            this.getObjectUnsafe().put(newName, tmp);
        }
        return this;
    }

    public ONode setValue(Object value) {
        this.value = value;
        this.type = DataType.resolveValueType(value);
        return this;
    }

    public ONode fill(Object source) {
        ONode oNode = ONode.ofBean(source, this.options);
        this.value = oNode.value;
        this.type = oNode.type;
        return this;
    }

    public ONode fillJson(String json) {
        return this.fill(ONode.ofJson(json, this.options));
    }

    public ONode setAll(Map<?, ?> map) {
        if (map == null) {
            return this;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.set(String.valueOf(entry.getKey()), entry.getValue());
        }
        return this;
    }

    public ONode set(String key, Object value) {
        ONode oNode = value == null ? new ONode(this.options, null) : (value instanceof ONode ? (ONode)value : (value instanceof Collection ? BeanEncoder.encode(value) : (value instanceof Map ? BeanEncoder.encode(value) : (value.getClass().isArray() ? new ONode(this.options).addAll(Arrays.asList((Object[])value)) : new ONode(this.options, value)))));
        this.getObject().put(key, oNode);
        return this;
    }

    public ONode get(int index) {
        List<ONode> self = this.getArray();
        int size = self.size();
        if (index < 0) {
            index += size;
        }
        if (index >= 0 && size > index) {
            return self.get(index);
        }
        return new ONode(this.options);
    }

    public ONode getOrNew(int index) {
        return this.getOrNew(index, null);
    }

    public ONode getOrNew(int index, Consumer<ONode> thenApply) {
        List<ONode> self = this.getArray();
        int size = self.size();
        if (index < 0) {
            index += size;
        }
        if (size > index) {
            return self.get(index);
        }
        ONode last = null;
        int count = index + 1 - size;
        for (int i = 0; i < count; ++i) {
            last = new ONode(this.options, null);
            if (thenApply != null) {
                thenApply.accept(last);
            }
            self.add(last);
        }
        return last;
    }

    public ONode getOrNull(int index) {
        if (this.isArray()) {
            int size = this.getArrayUnsafe().size();
            if (index < 0) {
                index += size;
            }
            if (index >= 0 && size > index) {
                return this.getArrayUnsafe().get(index);
            }
        }
        return null;
    }

    public ONode remove(int index) {
        List<ONode> self = this.getArray();
        int size = self.size();
        if (index < 0) {
            index += size;
        }
        return self.remove(index);
    }

    public ONode add(Object value) {
        ONode oNode = value instanceof ONode ? (ONode)value : (value instanceof Collection ? BeanEncoder.encode(value) : (value instanceof Map ? BeanEncoder.encode(value) : new ONode(this.options, value)));
        this.getArray().add(oNode);
        return this;
    }

    public ONode addAll(Collection collection) {
        if (collection == null) {
            return this;
        }
        for (Object o : collection) {
            this.add(o);
        }
        return this;
    }

    public ONode addNew() {
        this.asArray();
        ONode oNode = new ONode(this.options, null);
        this.getArrayUnsafe().add(oNode);
        return oNode;
    }

    public ONode then(Consumer<ONode> builder) {
        builder.accept(this);
        return this;
    }

    public int size() {
        if (this.isArray()) {
            return this.getArray().size();
        }
        if (this.isObject()) {
            return this.getObject().size();
        }
        return 0;
    }

    public void clear() {
        if (this.isObject()) {
            ((Map)this.value).clear();
        } else if (this.isArray()) {
            ((List)this.value).clear();
        } else {
            this.value = null;
            this.type = DataType.Null;
        }
    }

    public boolean hasKey(String key) {
        return this.isObject() && this.getObject().containsKey(key);
    }

    public boolean hasValue(Object value) {
        if (this.isObject()) {
            for (ONode n : this.getObject().values()) {
                if (!n.equals(value)) continue;
                return true;
            }
            return false;
        }
        if (this.isArray()) {
            for (ONode n : this.getArray()) {
                if (!n.equals(value)) continue;
                return true;
            }
            return false;
        }
        if (this.isValue()) {
            return this.getValue().equals(value);
        }
        return false;
    }

    public ONode select(String jsonpath) {
        return jsonPathProvider.select(this, jsonpath);
    }

    public boolean exists(String jsonpath) {
        return false == this.select(jsonpath).isUndefined();
    }

    public void delete(String jsonpath) {
        jsonPathProvider.delete(this, jsonpath);
    }

    public ONode create(String jsonpath) {
        return jsonPathProvider.create(this, jsonpath);
    }

    public static ONode ofBean(Object bean, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return BeanEncoder.encode(bean, Options.DEF_OPTIONS);
        }
        return BeanEncoder.encode(bean, Options.of(features));
    }

    public static ONode ofBean(Object bean, Options opts) {
        return BeanEncoder.encode(bean, opts);
    }

    public static ONode ofJson(String json, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return ONode.ofJson(json, Options.DEF_OPTIONS);
        }
        return ONode.ofJson(json, Options.of(features));
    }

    public static ONode ofJson(String json, Options opts) {
        try {
            return JsonReader.read(json, opts);
        }
        catch (SnackException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new SnackException(ex);
        }
    }

    public static ONode ofJson(Reader reader, Options opts) {
        try {
            return JsonReader.read(reader, opts);
        }
        catch (SnackException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new SnackException(ex);
        }
    }

    public <T> T bindTo(T target) {
        return BeanDecoder.decode(this, target.getClass(), target, this.options);
    }

    public <T> T toBean(Type type) {
        return BeanDecoder.decode(this, type, null, this.options);
    }

    public <T> T toBean(TypeRef<T> typeRef) {
        return this.toBean(typeRef.getType());
    }

    public <T> T toBean() {
        return this.toBean((Type)((Object)Object.class));
    }

    @Deprecated
    public <T> T toData() {
        return this.toBean();
    }

    public String toJson() {
        try {
            return JsonWriter.write(this, this.options);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void toJson(Writer writer) {
        try {
            JsonWriter.write(this, this.options, writer);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return this.isNull();
        }
        if (this.isArray()) {
            if (o instanceof ONode) {
                ONode o1 = (ONode)o;
                return o1.isArray() && Objects.equals(this.getArray(), o1.getArray());
            }
            return Objects.equals(this.getArray(), o);
        }
        if (this.isObject()) {
            if (o instanceof ONode) {
                ONode o1 = (ONode)o;
                return o1.isObject() && Objects.equals(this.getObject(), ((ONode)o).getObject());
            }
            return Objects.equals(this.getObject(), o);
        }
        if (this.isValue()) {
            if (o instanceof ONode) {
                ONode o1 = (ONode)o;
                return o1.isValue() && Objects.equals(this.getValue(), ((ONode)o).getValue());
            }
            return Objects.equals(this.getValue(), o);
        }
        if (o instanceof ONode) {
            return ((ONode)o).isNull();
        }
        return false;
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toJson();
    }

    public ONode usePaths() {
        PathSource.resolvePath(this);
        return this;
    }

    public ONode parent() {
        if (this.source == null) {
            return null;
        }
        return this.source.parent;
    }

    public ONode parents(int depth) {
        ONode tmp;
        if (this.source == null) {
            return null;
        }
        for (tmp = this; depth > 0 && tmp != null; tmp = tmp.parent(), --depth) {
        }
        return tmp;
    }

    public List<String> pathList() {
        ArrayList<String> paths = new ArrayList<String>();
        String tmp = this.path();
        if (tmp != null) {
            paths.add(tmp);
        }
        if (this.isArray()) {
            for (ONode node : this.getArray()) {
                tmp = node.path();
                if (tmp == null) continue;
                paths.add(tmp);
            }
        }
        return paths;
    }

    public String path() {
        if (this.path == null) {
            if (this.source == null) {
                this.path = null;
            } else {
                String parentPath = this.source.parent.path();
                this.path = this.source.key == null ? (Asserts.isEmpty(parentPath) ? "$[" + this.source.index + "]" : parentPath + "[" + this.source.index + "]") : (Asserts.isEmpty(parentPath) ? "$['" + this.source.key + "']" : parentPath + "['" + this.source.key + "']");
            }
        }
        return this.path;
    }

    public static String serialize(Object object, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return ONode.serialize(object, Options.DEF_OPTIONS);
        }
        return ONode.serialize(object, Options.of(features));
    }

    public static String serialize(Object object, Options opts) {
        return ONode.ofBean(object, opts).toJson();
    }

    public static <T> T deserialize(String json, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return ONode.deserialize(json, Object.class, Options.DEF_OPTIONS);
        }
        return ONode.deserialize(json, Object.class, Options.of(features));
    }

    public static <T> T deserialize(String json, Options opts) {
        return ONode.deserialize(json, Object.class, opts);
    }

    public static <T> T deserialize(String json, Type type, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return ONode.deserialize(json, type, Options.DEF_OPTIONS);
        }
        return ONode.deserialize(json, type, Options.of(features));
    }

    public static <T> T deserialize(String json, Type type, Options opts) {
        return ONode.ofJson(json, opts).toBean(type);
    }

    public static <T> T deserialize(String json, TypeRef<T> type, Feature ... features) {
        if (Asserts.isEmpty((Object[])features)) {
            return ONode.deserialize(json, type, Options.DEF_OPTIONS);
        }
        return ONode.deserialize(json, type, Options.of(features));
    }

    public static <T> T deserialize(String json, TypeRef<T> type, Options opts) {
        return ONode.ofJson(json, opts).toBean(type);
    }

    static {
        ServiceLoader<JsonPathProvider> jsonPathSL = ServiceLoader.load(JsonPathProvider.class);
        Iterator<JsonPathProvider> iterator = jsonPathSL.iterator();
        while (iterator.hasNext()) {
            JsonPathProvider provider;
            jsonPathProvider = provider = iterator.next();
        }
    }
}

