/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.OValueType;
import org.noear.snack.core.Context;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.NodeDecoder;
import org.noear.snack.core.NodeDecoderEntity;
import org.noear.snack.core.exts.ClassWrap;
import org.noear.snack.core.exts.EnumWrap;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.exts.Unitype;
import org.noear.snack.core.utils.BeanUtil;
import org.noear.snack.core.utils.GenericUtil;
import org.noear.snack.core.utils.ParameterizedTypeImpl;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.exception.SnackException;
import org.noear.snack.to.Toer;

public class ObjectToer
implements Toer {
    @Override
    public void handle(Context ctx) throws Exception {
        ONode o = (ONode)ctx.source;
        if (null != o) {
            ctx.target = this.analyse(ctx, o, ctx.target, ctx.target_clz, ctx.target_type, null);
        }
    }

    private Object analyse(Context ctx, ONode o, Object rst, Class<?> clz, Type type, Map<String, Type> genericInfo) throws Exception {
        if (o == null) {
            return rst;
        }
        if (clz != null && ONode.class.isAssignableFrom(clz)) {
            return o;
        }
        if (o.isNull()) {
            return rst;
        }
        if (o.isObject() || o.isArray()) {
            AtomicReference<ONode> oRef = new AtomicReference<ONode>(o);
            clz = this.getTypeByNode(ctx, oRef, clz);
            o = oRef.get();
        }
        if (clz != null) {
            if (NodeDecoder.class.isAssignableFrom(clz)) {
                NodeDecoder decoder = (NodeDecoder)BeanUtil.getInstance(clz);
                return decoder.decode(o, clz);
            }
            for (NodeDecoderEntity decoder : ctx.options.decoders()) {
                if (!decoder.isDecodable(clz)) continue;
                return decoder.decode(o, clz);
            }
        }
        if (String.class == clz) {
            return o.getString();
        }
        switch (o.nodeType()) {
            case Value: {
                if (clz != null) {
                    if (Collection.class.isAssignableFrom(clz)) {
                        if (TypeUtil.isEmptyCollection(rst) || ctx.options.hasFeature(Feature.DisableCollectionDefaults)) {
                            rst = TypeUtil.createCollection(clz, false);
                        }
                        if (rst != null) {
                            Object val1;
                            Type type1 = TypeUtil.getCollectionItemType(type);
                            if (type1 instanceof Class) {
                                val1 = this.analyseVal(ctx, o.nodeData(), (Class)type1);
                                ((Collection)rst).add(val1);
                                return rst;
                            }
                            val1 = this.analyseVal(ctx, o.nodeData(), null);
                            ((Collection)rst).add(val1);
                            return rst;
                        }
                    } else if (clz.isArray()) {
                        ONode d1 = new ONode(ctx.options);
                        d1.add(o);
                        return this.analyseArray(ctx, d1.nodeData(), clz);
                    }
                }
                return this.analyseVal(ctx, o.nodeData(), clz);
            }
            case Object: {
                o.remove(ctx.options.getTypePropertyName());
                if (Properties.class.isAssignableFrom(clz)) {
                    return this.analyseProps(ctx, o, (Properties)rst, clz, type, genericInfo);
                }
                if (Map.class.isAssignableFrom(clz)) {
                    return this.analyseMap(ctx, o, (Map)rst, clz, type, genericInfo);
                }
                if (StackTraceElement.class.isAssignableFrom(clz)) {
                    String declaringClass = o.get("declaringClass").getString();
                    if (declaringClass == null) {
                        declaringClass = o.get("className").getString();
                    }
                    return new StackTraceElement(declaringClass, o.get("methodName").getString(), o.get("fileName").getString(), o.get("lineNumber").getInt());
                }
                if (type instanceof ParameterizedType) {
                    genericInfo = GenericUtil.getGenericInfo(type);
                }
                return this.analyseBean(ctx, o, rst, clz, type, genericInfo);
            }
            case Array: {
                if (clz.isArray()) {
                    return this.analyseArray(ctx, o.nodeData(), clz);
                }
                if (rst instanceof Collection) {
                    return this.analyseCollection(ctx, o, (Collection)rst, clz, type, genericInfo);
                }
                return this.analyseCollection(ctx, o, null, clz, type, genericInfo);
            }
        }
        return rst;
    }

    private boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }

    public Object analyseVal(Context ctx, ONodeData d, Class<?> clz) throws Exception {
        OValue v = d.value;
        if (v.type() == OValueType.Null) {
            return null;
        }
        if (clz == null) {
            return v.getRaw();
        }
        if (clz == Byte.TYPE) {
            return (byte)v.getLong();
        }
        if (clz == Short.TYPE) {
            return v.getShort();
        }
        if (clz == Integer.TYPE) {
            return v.getInt();
        }
        if (clz == Long.TYPE) {
            return v.getLong();
        }
        if (clz == Float.TYPE) {
            return Float.valueOf(v.getFloat());
        }
        if (clz == Double.TYPE) {
            return v.getDouble();
        }
        if (clz == Boolean.TYPE) {
            return v.getBoolean();
        }
        if (clz == Character.TYPE) {
            return Character.valueOf(v.getChar());
        }
        if (this.is(Byte.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return (byte)v.getLong();
        }
        if (this.is(Short.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return v.getShort();
        }
        if (this.is(Integer.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return v.getInt();
        }
        if (this.is(Long.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return v.getLong();
        }
        if (this.is(Float.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return Float.valueOf(v.getFloat());
        }
        if (this.is(Double.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return v.getDouble();
        }
        if (this.is(Boolean.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return v.getBoolean();
        }
        if (this.is(Character.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            return Character.valueOf(v.getChar());
        }
        if (this.is(Duration.class, clz)) {
            if (v.isEmpty()) {
                return null;
            }
            String tmp = v.getString().toUpperCase();
            if (tmp.indexOf(80) != 0) {
                tmp = tmp.indexOf(68) > 0 ? "P" + tmp : "PT" + tmp;
            }
            return Duration.parse(tmp);
        }
        if (this.is(LongAdder.class, clz)) {
            LongAdder tmp = new LongAdder();
            tmp.add(v.getLong());
            return tmp;
        }
        if (this.is(DoubleAdder.class, clz)) {
            DoubleAdder tmp = new DoubleAdder();
            tmp.add(v.getDouble());
            return tmp;
        }
        if (this.is(String.class, clz)) {
            return v.getString();
        }
        if (this.is(URI.class, clz)) {
            return URI.create(v.getString());
        }
        if (this.is(Timestamp.class, clz)) {
            return new Timestamp(v.getLong());
        }
        if (this.is(Date.class, clz)) {
            return new Date(v.getLong());
        }
        if (this.is(Time.class, clz)) {
            return new Time(v.getLong());
        }
        if (this.is(java.util.Date.class, clz)) {
            return v.getDate();
        }
        if (this.is(OffsetDateTime.class, clz)) {
            java.util.Date date = v.getDate();
            if (null == date) {
                return null;
            }
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), DEFAULTS.DEF_TIME_ZONE.toZoneId());
        }
        if (this.is(ZonedDateTime.class, clz)) {
            java.util.Date date = v.getDate();
            if (null == date) {
                return null;
            }
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), DEFAULTS.DEF_TIME_ZONE.toZoneId());
        }
        if (this.is(LocalDateTime.class, clz)) {
            java.util.Date date = v.getDate();
            if (date == null) {
                return null;
            }
            return Instant.ofEpochMilli(date.getTime()).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalDateTime();
        }
        if (this.is(LocalDate.class, clz)) {
            java.util.Date date = v.getDate();
            if (date == null) {
                return null;
            }
            return Instant.ofEpochMilli(date.getTime()).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalDate();
        }
        if (this.is(LocalTime.class, clz)) {
            java.util.Date date = v.getDate();
            if (date == null) {
                return null;
            }
            return Instant.ofEpochMilli(date.getTime()).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalTime();
        }
        if (this.is(OffsetTime.class, clz)) {
            boolean haveOffset;
            java.util.Date date = v.getDate();
            if (date != null) {
                return Instant.ofEpochMilli(date.getTime()).atOffset(DEFAULTS.DEF_OFFSET).toOffsetTime();
            }
            String dateStr = v.getString();
            boolean bl = haveOffset = dateStr.contains("+") || dateStr.contains("-") || dateStr.contains("Z");
            if (haveOffset) {
                return OffsetTime.parse(dateStr);
            }
            return OffsetTime.parse(dateStr + DEFAULTS.DEF_OFFSET);
        }
        if (this.is(BigDecimal.class, clz)) {
            if (v.type() == OValueType.Number && v.getRawNumber() instanceof BigDecimal) {
                return v.getRawNumber();
            }
            return new BigDecimal(v.getString());
        }
        if (this.is(BigInteger.class, clz)) {
            if (v.type() == OValueType.Number && v.getRawNumber() instanceof BigInteger) {
                return v.getRawNumber();
            }
            return new BigInteger(v.getString());
        }
        if (clz.isEnum()) {
            if (v.isEmpty()) {
                return null;
            }
            return this.analyseEnum(ctx, d, clz);
        }
        if (this.is(Class.class, clz)) {
            return ctx.options.loadClass(v.getString());
        }
        if (this.is(File.class, clz)) {
            return new File(v.getString());
        }
        if (this.is(Charset.class, clz)) {
            return Charset.forName(v.getString());
        }
        if (this.is(Object.class, clz)) {
            Object val = v.getRaw();
            if (val instanceof String && (clz.isInterface() || Modifier.isAbstract(clz.getModifiers()))) {
                Class<?> valClz = ctx.options.loadClass((String)val);
                if (valClz == null) {
                    return null;
                }
                return BeanUtil.newInstance(valClz);
            }
            return val;
        }
        throw new SnackException("Unsupport type, class: " + clz.getName());
    }

    public Object analyseEnum(Context ctx, ONodeData d, Class<?> target) {
        Enum eItem;
        EnumWrap ew = TypeUtil.createEnum(target);
        String valString = d.value.getString();
        if (ew.hasCustom()) {
            eItem = ew.getCustom(valString);
            if (eItem == null) {
                eItem = ew.get(valString);
            }
        } else {
            eItem = d.value.type() == OValueType.String ? ew.get(valString) : ew.get(d.value.getInt());
        }
        if (eItem == null) {
            throw new SnackException("Deserialize failure for '" + ew.enumClass().getName() + "' from value: " + valString);
        }
        return eItem;
    }

    public Object analyseArray(Context ctx, ONodeData d, Class<?> target) throws Exception {
        int len = d.array.size();
        if (this.is(byte[].class, target)) {
            byte[] val = new byte[len];
            for (int i = 0; i < len; ++i) {
                val[i] = (byte)d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(short[].class, target)) {
            short[] val = new short[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getShort();
            }
            return val;
        }
        if (this.is(int[].class, target)) {
            int[] val = new int[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getInt();
            }
            return val;
        }
        if (this.is(long[].class, target)) {
            long[] val = new long[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(float[].class, target)) {
            float[] val = new float[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getFloat();
            }
            return val;
        }
        if (this.is(double[].class, target)) {
            double[] val = new double[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getDouble();
            }
            return val;
        }
        if (this.is(boolean[].class, target)) {
            boolean[] val = new boolean[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getBoolean();
            }
            return val;
        }
        if (this.is(char[].class, target)) {
            char[] val = new char[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getChar();
            }
            return val;
        }
        if (this.is(String[].class, target)) {
            String[] val = new String[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getString();
            }
            return val;
        }
        if (this.is(Object[].class, target)) {
            Class<?> c = target.getComponentType();
            Object[] val = (Object[])Array.newInstance(c, len);
            for (int i = 0; i < len; ++i) {
                val[i] = this.analyse(ctx, d.array.get(i), null, c, c, null);
            }
            return val;
        }
        throw new SnackException("Unsupport type, class: " + target.getName());
    }

    public Object analyseCollection(Context ctx, ONode o, Collection coll, Class<?> clz, Type type, Map<String, Type> genericInfo) throws Exception {
        if (TypeUtil.isEmptyCollection(coll) || ctx.options.hasFeature(Feature.DisableCollectionDefaults)) {
            coll = TypeUtil.createCollection(clz, false);
        }
        if (coll == null) {
            return coll;
        }
        Class itemClz = null;
        Type itemType = null;
        if (ctx.target_type != null) {
            itemType = TypeUtil.getCollectionItemType(type);
            if (itemType instanceof Class) {
                itemClz = (Class)itemType;
            } else if (itemType instanceof ParameterizedType) {
                itemClz = (Class)((ParameterizedType)itemType).getRawType();
            }
        }
        if (itemType != null && itemType instanceof TypeVariable) {
            itemType = null;
        }
        for (ONode o1 : o.nodeData().array) {
            coll.add(this.analyse(ctx, o1, null, itemClz, itemType, genericInfo));
        }
        return coll;
    }

    public Object analyseProps(Context ctx, ONode o, Properties rst, Class<?> clz, Type type, Map<String, Type> genericInfo) throws Exception {
        if (rst == null) {
            rst = new Properties();
        }
        String prefix = "";
        this.propsLoad0(rst, prefix, o);
        return rst;
    }

    private void propsLoad0(Properties props, String prefix, ONode tmp) {
        if (tmp.isObject()) {
            tmp.forEach((k, v) -> {
                String prefix2 = prefix + "." + k;
                this.propsLoad0(props, prefix2, (ONode)v);
            });
            return;
        }
        if (tmp.isArray()) {
            int index = 0;
            for (ONode v2 : tmp.ary()) {
                String prefix2 = prefix + "[" + index + "]";
                this.propsLoad0(props, prefix2, v2);
                ++index;
            }
            return;
        }
        if (tmp.isNull()) {
            this.propsPut0(props, prefix, "");
        } else {
            this.propsPut0(props, prefix, tmp.getString());
        }
    }

    private void propsPut0(Properties props, String key, Object val) {
        if (key.startsWith(".")) {
            props.put(key.substring(1), val);
        } else {
            props.put(key, val);
        }
    }

    public Object analyseMap(Context ctx, ONode o, Map<Object, Object> map, Class<?> clz, Type type, Map<String, Type> genericInfo) throws Exception {
        if (TypeUtil.isEmptyCollection(map) || ctx.options.hasFeature(Feature.DisableCollectionDefaults)) {
            map = TypeUtil.createMap(clz);
        }
        if (map == null) {
            return map;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)type;
            Type kType = ptt.getActualTypeArguments()[0];
            Type vType = ptt.getActualTypeArguments()[1];
            Class vClass = null;
            if (kType instanceof ParameterizedType) {
                kType = ((ParameterizedType)kType).getRawType();
            }
            if (vType instanceof Class) {
                vClass = (Class)vType;
            } else if (vType instanceof ParameterizedType) {
                vClass = (Class)((ParameterizedType)vType).getRawType();
            }
            if (kType == String.class) {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(kv.getKey(), this.analyse(ctx, kv.getValue(), null, vClass, vType, genericInfo));
                }
            } else {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(TypeUtil.strTo(kv.getKey(), (Class)kType), this.analyse(ctx, kv.getValue(), null, vClass, vType, genericInfo));
                }
            }
        } else {
            for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                map.put(kv.getKey(), this.analyse(ctx, kv.getValue(), null, null, null, genericInfo));
            }
        }
        return map;
    }

    public Object analyseBean(Context ctx, ONode o, Object rst, Class<?> clz, Type type, Map<String, Type> genericInfo) throws Exception {
        ClassWrap clzWrap;
        String message;
        if (this.is(SimpleDateFormat.class, clz)) {
            return new SimpleDateFormat(o.get("val").getString());
        }
        if (this.is(InetSocketAddress.class, clz)) {
            return new InetSocketAddress(o.get("address").getString(), o.get("port").getInt());
        }
        if (this.is(Throwable.class, clz) && !StringUtil.isEmpty(message = o.get("message").getString())) {
            try {
                Constructor<?> fun = clz.getConstructor(String.class);
                rst = fun.newInstance(message);
            }
            catch (Throwable fun) {
                // empty catch block
            }
        }
        if ((clzWrap = ClassWrap.get(new Unitype(clz, type))).recordable()) {
            Parameter[] argsP = clzWrap.recordParams();
            Object[] argsV = new Object[argsP.length];
            for (int j = 0; j < argsP.length; ++j) {
                Object val;
                Parameter f = argsP[j];
                String fieldK = f.getName();
                if (!o.contains(fieldK)) continue;
                Class<?> fieldT = f.getType();
                Type type2 = f.getParameterizedType();
                argsV[j] = val = this.analyseBeanOfValue(fieldK, fieldT, type2, ctx, o, null, genericInfo);
            }
            rst = BeanUtil.newInstance(clzWrap.recordConstructor(), argsV);
        } else {
            LinkedHashSet<String> excNames = null;
            if (rst == null) {
                if (clzWrap.recordConstructor() == null) {
                    rst = BeanUtil.newInstance(clz);
                } else {
                    excNames = new LinkedHashSet<String>();
                    Parameter[] argsP = clzWrap.recordParams();
                    Object[] argsV = new Object[argsP.length];
                    for (int j = 0; j < argsP.length; ++j) {
                        Object val;
                        Parameter f = argsP[j];
                        String fieldK = f.getName();
                        excNames.add(fieldK);
                        if (!o.contains(fieldK)) continue;
                        Class<?> clazz = f.getType();
                        Type fieldGt = f.getParameterizedType();
                        argsV[j] = val = this.analyseBeanOfValue(fieldK, clazz, fieldGt, ctx, o, null, genericInfo);
                    }
                    rst = BeanUtil.newInstance(clzWrap.recordConstructor(), argsV);
                }
            }
            if (rst == null) {
                return null;
            }
            boolean useSetter = ctx.options.hasFeature(Feature.UseSetter);
            boolean useOnlySetter = ctx.options.hasFeature(Feature.UseOnlySetter);
            if (useOnlySetter) {
                useSetter = true;
            }
            boolean useGetter = ctx.options.hasFeature(Feature.UseGetter);
            boolean useOnlyGetter = ctx.options.hasFeature(Feature.UseOnlyGetter);
            if (useOnlyGetter) {
                useGetter = true;
            }
            if (useSetter) {
                for (Map.Entry entry : o.obj().entrySet()) {
                    FieldWrap f = clzWrap.getFieldWrap((String)entry.getKey());
                    if (f != null) {
                        if (useOnlySetter && !f.hasSetter) continue;
                        this.setValueForField(ctx, o, rst, genericInfo, f, useSetter, useGetter, excNames);
                        continue;
                    }
                    Method m = clzWrap.getProperty((String)entry.getKey());
                    if (m == null) continue;
                    this.setValueForMethod(ctx, o, rst, genericInfo, (String)entry.getKey(), m);
                }
            } else {
                for (FieldWrap fieldWrap : clzWrap.fieldAllWraps()) {
                    if (useOnlySetter && !fieldWrap.hasSetter) continue;
                    this.setValueForField(ctx, o, rst, genericInfo, fieldWrap, useSetter, useGetter, excNames);
                }
            }
        }
        return rst;
    }

    private void setValueForMethod(Context ctx, ONode o, Object rst, Map<String, Type> genericInfo, String name, Method method) throws Exception {
        Class<?> fieldT = method.getParameterTypes()[0];
        Object val = this.analyseBeanOfValue(name, fieldT, null, ctx, o, null, genericInfo);
        if (val == null && ctx.options.hasFeature(Feature.StringFieldInitEmpty) && fieldT == String.class) {
            val = "";
        }
        method.invoke(rst, val);
    }

    private void setValueForField(Context ctx, ONode o, Object rst, Map<String, Type> genericInfo, FieldWrap f, boolean useSetter, boolean useGetter, Set<String> excNames) throws Exception {
        if (!f.isDeserialize()) {
            return;
        }
        String fieldK = f.getName();
        if (excNames != null && excNames.contains(fieldK)) {
            return;
        }
        if (f.isFlat()) {
            fieldK = null;
        }
        if (f.isFlat() || o.contains(fieldK)) {
            Class<?> fieldT = f.getType();
            Type fieldGt = f.getGenericType();
            if (f.readonly) {
                this.analyseBeanOfValue(fieldK, fieldT, fieldGt, ctx, o, f.getValue(rst, useGetter), genericInfo);
            } else {
                Object val = this.analyseBeanOfValue(fieldK, fieldT, fieldGt, ctx, o, f.getValue(rst, useGetter), genericInfo);
                if (val == null && ctx.options.hasFeature(Feature.StringFieldInitEmpty) && f.getType() == String.class) {
                    val = "";
                }
                f.setValue(rst, val, useSetter);
            }
        }
    }

    private Object analyseBeanOfValue(String fieldK, Class fieldT, Type fieldGt, Context ctx, ONode o, Object rst, Map<String, Type> genericInfo) throws Exception {
        if (genericInfo != null) {
            Type tmp;
            if (fieldGt instanceof TypeVariable && (tmp = genericInfo.get(fieldGt.getTypeName())) != null) {
                fieldGt = tmp;
                if (tmp instanceof Class) {
                    fieldT = (Class)tmp;
                }
            }
            if (fieldGt instanceof ParameterizedType) {
                ParameterizedType fieldGt2 = (ParameterizedType)fieldGt;
                Type[] actualTypes = fieldGt2.getActualTypeArguments();
                boolean actualTypesChanged = false;
                fieldT = (Class)fieldGt2.getRawType();
                int len = actualTypes.length;
                for (int i = 0; i < len; ++i) {
                    Type tmp2 = actualTypes[i];
                    if (!(tmp2 instanceof TypeVariable) || (tmp2 = genericInfo.get(tmp2.getTypeName())) == null) continue;
                    actualTypes[i] = tmp2;
                    actualTypesChanged = true;
                }
                if (actualTypesChanged) {
                    fieldGt = new ParameterizedTypeImpl((Class)fieldGt2.getRawType(), actualTypes, fieldGt2.getOwnerType());
                }
            }
        }
        if (fieldK == null) {
            return this.analyse(ctx, o, rst, fieldT, fieldGt, genericInfo);
        }
        return this.analyse(ctx, o.get(fieldK), rst, fieldT, fieldGt, genericInfo);
    }

    private Class<?> getTypeByNode(Context ctx, AtomicReference<ONode> oRef, Class<?> def) {
        Class<?> clz0 = this.getTypeByNode0(ctx, oRef, def);
        if (Throwable.class.isAssignableFrom(clz0)) {
            return clz0;
        }
        if (def != null && def != Object.class && !def.isInterface() && !Modifier.isAbstract(def.getModifiers())) {
            return def;
        }
        return clz0;
    }

    private Class<?> getTypeByNode0(Context ctx, AtomicReference<ONode> oRef, Class<?> def) {
        ONode o = oRef.get();
        if (ctx.target_type == null) {
            if (o.isObject()) {
                return LinkedHashMap.class;
            }
            if (o.isArray()) {
                return ArrayList.class;
            }
        }
        String typeStr = null;
        if (!ctx.options.hasFeature(Feature.DisableClassNameRead)) {
            ONode n1;
            ONode n12;
            ONode o1;
            if (o.isArray() && o.ary().size() == 2 && (o1 = o.ary().get(0)).isObject() && o1.obj().size() == 1 && (n12 = o1.obj().get(ctx.options.getTypePropertyName())) != null) {
                typeStr = n12.val().getString();
                ONode o2 = o.ary().get(1);
                oRef.set(o2);
            }
            if (o.isObject() && (n1 = o.obj().get(ctx.options.getTypePropertyName())) != null) {
                typeStr = n1.val().getString();
            }
        }
        if (!StringUtil.isEmpty(typeStr)) {
            if (typeStr.startsWith("sun.") || typeStr.startsWith("com.sun.") || typeStr.startsWith("javax.") || typeStr.startsWith("jdk.")) {
                throw new SnackException("Unsupported type, class: " + typeStr);
            }
            Class<?> clz = ctx.options.loadClass(typeStr);
            if (clz == null) {
                throw new SnackException("Unsupported type, class: " + typeStr);
            }
            return clz;
        }
        if (def == null || def == Object.class) {
            if (o.isObject()) {
                return LinkedHashMap.class;
            }
            if (o.isArray()) {
                return ArrayList.class;
            }
        }
        return def;
    }
}

