/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.io.ReadListener;
import org.smartboot.socket.transport.AioSession;

public class PostInputStream
extends BodyInputStream {
    private final long maxPayload;
    private long remaining;

    public PostInputStream(AioSession session, long contentLength, long maxPayload) {
        super(session);
        this.remaining = contentLength;
        this.maxPayload = maxPayload;
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        if (this.maxPayload > 0L && this.remaining > this.maxPayload) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
        this.checkState();
        if (data == null) {
            throw new NullPointerException();
        }
        if (this.isFinished()) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.session.readBuffer();
        if (this.readListener != null) {
            if (PostInputStream.anyAreClear(this.state, 9)) {
                throw new IllegalStateException();
            }
            this.clearFlags(8);
        } else if (this.remaining > 0L && !byteBuffer.hasRemaining()) {
            try {
                this.session.read();
            }
            catch (IOException e) {
                if (this.readListener != null) {
                    this.readListener.onError(e);
                }
                throw e;
            }
        }
        int readLength = Math.min(len, byteBuffer.remaining());
        if (this.remaining < (long)readLength) {
            readLength = (int)this.remaining;
        }
        byteBuffer.get(data, off, readLength);
        this.remaining -= (long)readLength;
        if (this.remaining > 0L) {
            if (this.readListener == null) {
                return readLength + this.read(data, off + readLength, len - readLength);
            }
            if (!byteBuffer.hasRemaining()) {
                this.clearFlags(1);
            }
            return readLength;
        }
        this.setFlags(2);
        return readLength;
    }

    @Override
    public void setReadListener(final ReadListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.readListener != null) {
            throw new IllegalStateException();
        }
        this.readListener = new ReadListener(){

            @Override
            public void onDataAvailable() throws IOException {
                PostInputStream.this.setFlags(1);
                listener.onDataAvailable();
                PostInputStream.this.clearFlags(1);
                if (PostInputStream.this.remaining == 0L) {
                    listener.onAllDataRead();
                }
            }

            @Override
            public void onAllDataRead() throws IOException {
                listener.onAllDataRead();
            }

            @Override
            public void onError(Throwable t) {
                listener.onError(t);
            }
        };
    }
}

