/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.smartboot.http.common.io.ReadListener;
import org.smartboot.socket.transport.AioSession;

public abstract class BodyInputStream
extends InputStream {
    public static final BodyInputStream EMPTY_INPUT_STREAM = new BodyInputStream(null){

        @Override
        public void setReadListener(ReadListener listener) {
            throw new IllegalStateException();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isFinished() {
            return true;
        }
    };
    protected final AioSession session;
    protected ReadListener readListener;
    protected volatile int state;
    protected static final int FLAG_READY = 1;
    protected static final int FLAG_FINISHED = 2;
    protected static final int FLAG_CLOSED = 4;
    protected static final int FLAG_IS_READY_CALLED = 8;
    protected static final int FLAG_CHUNKED_TRAILER = 16;
    protected static final int FLAG_EXPECT_CR_LF = 32;
    protected static final int FLAG_READ_CHUNKED_LENGTH = 64;
    protected static final AtomicIntegerFieldUpdater<BodyInputStream> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(BodyInputStream.class, "state");

    public BodyInputStream(AioSession session) {
        this.session = session;
    }

    @Override
    public void close() throws IOException {
        this.setFlags(6);
    }

    @Override
    public final int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public abstract void setReadListener(ReadListener var1);

    public ReadListener getReadListener() {
        return this.readListener;
    }

    public boolean isFinished() {
        return this.anyAreSet(this.state, 2);
    }

    protected void checkState() throws IOException {
        if (this.anyAreSet(this.state, 4)) {
            throw new IOException("stream closed");
        }
    }

    public boolean isReady() {
        if (this.readListener == null) {
            return true;
        }
        return this.anyAreSet(this.state, 1) && this.session.readBuffer().hasRemaining();
    }

    @Override
    public int available() throws IOException {
        this.checkState();
        return this.session.readBuffer().remaining();
    }

    protected static boolean anyAreClear(int var, int flags) {
        return (var & flags) != flags;
    }

    protected void clearFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old & ~flags)) {
        }
    }

    protected void setFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old | flags)) {
        }
    }

    protected boolean anyAreSet(int var, int flags) {
        return (var & flags) != 0;
    }
}

