/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.websocket;

import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.PayloadDecoder;
import org.smartboot.http.common.codec.websocket.WebSocket;

class MaskingKeyDecoder
implements Decoder {
    private final Decoder payloadDecoder = new PayloadDecoder();

    MaskingKeyDecoder() {
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocket request) {
        if (request.isFrameMasked()) {
            if (byteBuffer.remaining() < 4) {
                return this;
            }
            byte[] maskingKey = new byte[4];
            byteBuffer.get(maskingKey);
            request.setMaskingKey(maskingKey);
        }
        return this.payloadDecoder.decode(byteBuffer, request);
    }
}

