/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.socket.transport.WriteBuffer;

public abstract class Http2Frame {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    public static final int FRAME_TYPE_DATA = 0;
    public static final int FRAME_TYPE_HEADERS = 1;
    public static final int FRAME_TYPE_PRIORITY = 2;
    public static final int FRAME_TYPE_RST_STREAM = 3;
    public static final int FRAME_TYPE_SETTINGS = 4;
    public static final int FRAME_TYPE_PUSH_PROMISE = 5;
    public static final int FRAME_TYPE_PING = 6;
    public static final int FRAME_TYPE_GOAWAY = 7;
    public static final int FRAME_TYPE_WINDOW_UPDATE = 8;
    public static final int FRAME_TYPE_CONTINUATION = 9;
    protected static final byte[] EMPTY_PADDING = new byte[0];
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    protected final int streamId;
    protected final int flags;
    protected int remaining;
    protected static final int STATE_PAD_LENGTH = 0;
    protected static final int STATE_STREAM_DEPENDENCY = 1;
    protected static final int STATE_STREAM_ID = 1;
    protected static final int STATE_FRAGMENT = 2;
    protected static final int STATE_PADDING = 3;
    protected int state = 0;

    public Http2Frame(int streamId, int flags, int remaining) {
        this.streamId = streamId;
        this.flags = flags;
        this.remaining = remaining;
    }

    public int streamId() {
        return this.streamId;
    }

    public int getFlags() {
        return this.flags;
    }

    public final boolean getFlag(int flag) {
        return this.hasFlag(this.flags, flag);
    }

    protected final boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    protected boolean finishDecode() {
        if (this.remaining < 0) {
            throw new IllegalStateException();
        }
        return this.remaining == 0;
    }

    protected void checkEndRemaining() {
        if (this.remaining != 0) {
            throw new IllegalStateException();
        }
    }

    public abstract boolean decode(ByteBuffer var1);

    public void writeTo(WriteBuffer writeBuffer) throws IOException {
        throw new IllegalStateException();
    }

    public abstract int type();
}

