/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.HeaderValue;

public class HpackEncoder {
    private static final int STATIC_TABLE_LENGTH = 61;
    private static final Map<String, Integer> STATIC_TABLE_MAP = HpackEncoder.createStaticTableMap();
    private static final HuffmanEncoder HUFFMAN_ENCODER = new HuffmanEncoder();
    private final List<HeaderValue> dynamicTable = new ArrayList<HeaderValue>();
    private final Map<String, Integer> dynamicTableMap = new HashMap<String, Integer>();
    private int dynamicTableSize = 0;
    private int maxDynamicTableSize;

    public HpackEncoder(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    public ByteBuffer encode(Collection<HeaderValue> headers) throws HpackException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        for (HeaderValue header : headers) {
            this.encodeHeader(buffer, header);
        }
        buffer.flip();
        return buffer;
    }

    private void encodeHeader(ByteBuffer buffer, HeaderValue header) throws HpackException {
        Integer staticIndex = STATIC_TABLE_MAP.get(header.getName() + ": " + header.getValue());
        if (staticIndex != null) {
            this.encodeInteger(buffer, 7, staticIndex);
            buffer.put((byte)(0x80 | buffer.get(buffer.position() - 1)));
            return;
        }
        Integer dynamicIndex = this.dynamicTableMap.get(header.getName() + ": " + header.getValue());
        if (dynamicIndex != null) {
            this.encodeInteger(buffer, 7, dynamicIndex + 61);
            buffer.put((byte)(0x80 | buffer.get(buffer.position() - 1)));
            return;
        }
        staticIndex = STATIC_TABLE_MAP.get(header.getName() + ": ");
        if (staticIndex != null) {
            this.encodeInteger(buffer, 6, staticIndex);
            buffer.put((byte)(0x40 | buffer.get(buffer.position() - 1)));
            this.encodeString(buffer, header.getValue());
        } else {
            buffer.put((byte)64);
            this.encodeString(buffer, header.getName());
            this.encodeString(buffer, header.getValue());
        }
        this.addToDynamicTable(header);
    }

    private void addToDynamicTable(HeaderValue header) {
        int headerSize = header.getName().length() + header.getValue().length() + 32;
        while (this.dynamicTableSize + headerSize > this.maxDynamicTableSize && !this.dynamicTable.isEmpty()) {
            HeaderValue removed = this.dynamicTable.remove(this.dynamicTable.size() - 1);
            this.dynamicTableSize -= removed.getName().length() + removed.getValue().length() + 32;
            this.dynamicTableMap.remove(removed.getName() + ": " + removed.getValue());
        }
        if (headerSize <= this.maxDynamicTableSize) {
            this.dynamicTable.add(0, header);
            this.dynamicTableSize += headerSize;
            this.dynamicTableMap.put(header.getName() + ": " + header.getValue(), 1);
            for (Map.Entry<String, Integer> entry : this.dynamicTableMap.entrySet()) {
                entry.setValue(entry.getValue() + 1);
            }
        }
    }

    private void encodeInteger(ByteBuffer buffer, int n, int i) throws HpackException {
        int limit = (1 << n) - 1;
        if (i < limit) {
            buffer.put((byte)i);
        } else {
            buffer.put((byte)limit);
            i -= limit;
            while (i >= 128) {
                buffer.put((byte)(0x80 | i & 0x7F));
                i >>>= 7;
            }
            buffer.put((byte)i);
        }
    }

    private void encodeString(ByteBuffer buffer, String s) throws HpackException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        byte[] huffmanEncoded = HUFFMAN_ENCODER.encode(bytes);
        if (huffmanEncoded.length < bytes.length) {
            this.encodeInteger(buffer, 7, huffmanEncoded.length);
            buffer.put((byte)(0x80 | buffer.get(buffer.position() - 1)));
            buffer.put(huffmanEncoded);
        } else {
            this.encodeInteger(buffer, 7, bytes.length);
            buffer.put(bytes);
        }
    }

    public void setMaxDynamicTableSize(int newMaxDynamicTableSize) throws HpackException {
        if (newMaxDynamicTableSize < 0) {
            throw new HpackException("Invalid dynamic table size: " + newMaxDynamicTableSize);
        }
        this.maxDynamicTableSize = newMaxDynamicTableSize;
        while (this.dynamicTableSize > this.maxDynamicTableSize && !this.dynamicTable.isEmpty()) {
            HeaderValue removed = this.dynamicTable.remove(this.dynamicTable.size() - 1);
            this.dynamicTableSize -= removed.getName().length() + removed.getValue().length() + 32;
            this.dynamicTableMap.remove(removed.getName() + ": " + removed.getValue());
        }
    }

    private static Map<String, Integer> createStaticTableMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(":authority: ", 1);
        map.put(":method: GET", 2);
        map.put(":method: POST", 3);
        map.put(":path: /", 4);
        map.put(":path: /index.html", 5);
        map.put(":scheme: http", 6);
        map.put(":scheme: https", 7);
        map.put(":status: 200", 8);
        map.put(":status: 204", 9);
        map.put(":status: 206", 10);
        map.put(":status: 304", 11);
        map.put(":status: 400", 12);
        map.put(":status: 404", 13);
        map.put(":status: 500", 14);
        map.put("accept-charset: ", 15);
        map.put("accept-encoding: gzip, deflate", 16);
        map.put("accept-language: ", 17);
        map.put("accept-ranges: ", 18);
        map.put("accept: ", 19);
        map.put("access-control-allow-origin: ", 20);
        map.put("age: ", 21);
        map.put("allow: ", 22);
        map.put("authorization: ", 23);
        map.put("cache-control: ", 24);
        map.put("content-disposition: ", 25);
        map.put("content-encoding: ", 26);
        map.put("content-language: ", 27);
        map.put("content-length: ", 28);
        map.put("content-location: ", 29);
        map.put("content-range: ", 30);
        map.put("content-type: ", 31);
        map.put("cookie: ", 32);
        map.put("date: ", 33);
        map.put("etag: ", 34);
        map.put("expect: ", 35);
        map.put("expires: ", 36);
        map.put("from: ", 37);
        map.put("host: ", 38);
        map.put("if-match: ", 39);
        map.put("if-modified-since: ", 40);
        map.put("if-none-match: ", 41);
        map.put("if-range: ", 42);
        map.put("if-unmodified-since: ", 43);
        map.put("last-modified: ", 44);
        map.put("link: ", 45);
        map.put("location: ", 46);
        map.put("max-forwards: ", 47);
        map.put("proxy-authenticate: ", 48);
        map.put("proxy-authorization: ", 49);
        map.put("range: ", 50);
        map.put("referer: ", 51);
        map.put("refresh: ", 52);
        map.put("retry-after: ", 53);
        map.put("server: ", 54);
        map.put("set-cookie: ", 55);
        map.put("strict-transport-security: ", 56);
        map.put("transfer-encoding: ", 57);
        map.put("user-agent: ", 58);
        map.put("vary: ", 59);
        map.put("via: ", 60);
        map.put("www-authenticate: ", 61);
        return map;
    }

    private static class HuffmanEncoder {
        private static final int[] CODES = new int[]{8184, 8388568, 0xFFFFFE2, 0xFFFFFE3, 0xFFFFFE4, 0xFFFFFE5, 0xFFFFFE6, 0xFFFFFE7, 0xFFFFFE8, 0xFFFFEA, 0x3FFFFFFC, 0xFFFFFE9, 0xFFFFFEA, 0x3FFFFFFD, 0xFFFFFEB, 0xFFFFFEC, 0xFFFFFED, 0xFFFFFEE, 0xFFFFFEF, 0xFFFFFF0, 0xFFFFFF1, 0xFFFFFF2, 0x3FFFFFFE, 0xFFFFFF3, 0xFFFFFF4, 0xFFFFFF5, 0xFFFFFF6, 0xFFFFFF7, 0xFFFFFF8, 0xFFFFFF9, 0xFFFFFFA, 0xFFFFFFB, 20, 1016, 1017, 4090, 8185, 21, 248, 2042, 1018, 1019, 249, 2043, 250, 22, 23, 24, 0, 1, 2, 25, 26, 27, 28, 29, 30, 31, 92, 251, 32764, 32, 4091, 1020, 8186, 33, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 252, 115, 253, 8187, 524272, 8188, 16380, 34, 32765, 3, 35, 4, 36, 5, 37, 38, 39, 6, 116, 117, 40, 41, 42, 7, 43, 118, 44, 8, 9, 45, 119, 120, 121, 122, 123, 32766, 2044, 16381, 8189, 0xFFFFFFC, 1048550, 4194258, 1048551, 1048552, 0x3FFFD3, 4194260, 4194261, 8388569, 4194262, 8388570, 8388571, 8388572, 0x7FFFDD, 8388574, 0xFFFFEB, 0x7FFFDF, 0xFFFFEC, 0xFFFFED, 4194263, 8388576, 0xFFFFEE, 8388577, 8388578, 8388579, 8388580, 2097116, 4194264, 8388581, 4194265, 8388582, 0x7FFFE7, 0xFFFFEF, 4194266, 0x1FFFDD, 1048553, 4194267, 4194268, 8388584, 8388585, 2097118, 8388586, 0x3FFFDD, 4194270, 0xFFFFF0, 0x1FFFDF, 0x3FFFDF, 8388587, 8388588, 2097120, 0x1FFFE1, 4194272, 2097122, 8388589, 4194273, 0x7FFFEE, 0x7FFFEF, 1048554, 4194274, 0x3FFFE3, 4194276, 0x7FFFF0, 4194277, 4194278, 0x7FFFF1, 67108832, 67108833, 1048555, 524273, 4194279, 0x7FFFF2, 4194280, 33554412, 67108834, 0x3FFFFE3, 67108836, 134217694, 0x7FFFFDF, 67108837, 0xFFFFF1, 33554413, 524274, 2097123, 67108838, 134217696, 134217697, 67108839, 134217698, 0xFFFFF2, 2097124, 2097125, 67108840, 67108841, 0xFFFFFFD, 134217699, 134217700, 134217701, 1048556, 0xFFFFF3, 1048557, 2097126, 4194281, 2097127, 2097128, 0x7FFFF3, 4194282, 4194283, 0x1FFFFEE, 0x1FFFFEF, 0xFFFFF4, 0xFFFFF5, 67108842, 0x7FFFF4, 67108843, 134217702, 67108844, 67108845, 0x7FFFFE7, 134217704, 134217705, 134217706, 134217707, 0xFFFFFFE, 134217708, 134217709, 0x7FFFFEE, 0x7FFFFEF, 0x7FFFFF0, 0x3FFFFEE};
        private static final byte[] LENGTHS = new byte[]{13, 23, 28, 28, 28, 28, 28, 28, 28, 24, 30, 28, 28, 30, 28, 28, 28, 28, 28, 28, 28, 28, 30, 28, 28, 28, 28, 28, 28, 28, 28, 28, 6, 10, 10, 12, 13, 6, 8, 11, 10, 10, 8, 11, 8, 6, 6, 6, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 8, 15, 6, 12, 10, 13, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 7, 8, 13, 19, 13, 14, 6, 15, 5, 6, 5, 6, 5, 6, 6, 6, 5, 7, 7, 6, 6, 6, 5, 6, 7, 6, 5, 5, 6, 7, 7, 7, 7, 7, 15, 11, 14, 13, 28, 20, 22, 20, 20, 22, 22, 22, 23, 22, 23, 23, 23, 23, 23, 24, 23, 24, 24, 22, 23, 24, 23, 23, 23, 23, 21, 22, 23, 22, 23, 23, 24, 22, 21, 20, 22, 22, 23, 23, 21, 23, 22, 22, 24, 21, 22, 23, 23, 21, 21, 22, 21, 23, 22, 23, 23, 20, 22, 22, 22, 23, 22, 22, 23, 26, 26, 20, 19, 22, 23, 22, 25, 26, 26, 26, 27, 27, 26, 24, 25, 19, 21, 26, 27, 27, 26, 27, 24, 21, 21, 26, 26, 28, 27, 27, 27, 20, 24, 20, 21, 22, 21, 21, 23, 22, 22, 25, 25, 24, 24, 26, 23, 26, 27, 26, 26, 27, 27, 27, 27, 27, 28, 27, 27, 27, 27, 27, 26};

        private HuffmanEncoder() {
        }

        public byte[] encode(byte[] data) {
            int bitLength = 0;
            for (byte by : data) {
                bitLength += LENGTHS[by & 0xFF];
            }
            byte[] result = new byte[(bitLength + 7) / 8];
            int bitPosition = 0;
            for (byte b : data) {
                int index = b & 0xFF;
                int code = CODES[index];
                byte codeLength = LENGTHS[index];
                bitPosition = this.writeCode(result, bitPosition, code, codeLength);
            }
            if (bitPosition % 8 != 0) {
                int paddingLength = 8 - bitPosition % 8;
                int n = (1 << paddingLength) - 1;
                this.writeCode(result, bitPosition, n, paddingLength);
            }
            return result;
        }

        private int writeCode(byte[] result, int bitPosition, int code, int codeLength) {
            int bytePosition = bitPosition / 8;
            int bitOffset = bitPosition % 8;
            code <<= 32 - codeLength;
            while (codeLength > 0) {
                int bitsToWrite = Math.min(8 - bitOffset, codeLength);
                int mask = 255 >>> bitOffset;
                int n = bytePosition;
                result[n] = (byte)(result[n] & ~mask);
                int n2 = bytePosition++;
                result[n2] = (byte)(result[n2] | code >>> 24 & mask);
                code <<= bitsToWrite;
                codeLength -= bitsToWrite;
                if ((bitOffset = (bitOffset + bitsToWrite) % 8) != 0) continue;
            }
            return bytePosition * 8 + bitOffset;
        }
    }

    public static class HpackException
    extends Exception {
        public HpackException(String message) {
            super(message);
        }
    }

    public static class Header {
        public final String name;
        public final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + ": " + this.value;
        }
    }
}

