/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.nami.Config;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiAttachment;
import org.noear.nami.NamiBuilder;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiException;
import org.noear.nami.NamiManager;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.MethodDesc;
import org.noear.nami.common.MethodHandlerUtils;
import org.noear.nami.common.ParameterDesc;
import org.noear.nami.common.TextUtils;
import org.noear.nami.common.UpstreamFixed;

public class NamiHandler
implements InvocationHandler {
    private static final Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");
    private final Config config;
    private final NamiClient client;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final Class<?> clz0;
    private final Map<String, Map> pathKeysCached = new ConcurrentHashMap<String, Map>();

    public NamiHandler(Class<?> clz, Config config, NamiClient client) {
        this.config = config;
        this.client = client;
        this.clz0 = clz;
        try {
            this.init();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws Exception {
        if (this.client != null) {
            for (Filter mi : NamiManager.getFilters()) {
                this.config.filterAdd(mi);
            }
            NamiConfiguration tmp = NamiManager.getConfigurator(this.client.configuration());
            if (tmp != null) {
                tmp.config(this.client, new NamiBuilder(this.config));
            }
            if (this.client.timeout() > 0) {
                this.config.setTimeout(this.client.timeout());
            }
            if (this.client.heartbeat() > 0) {
                this.config.setHeartbeat(this.client.heartbeat());
            }
            if (TextUtils.isNotEmpty(this.client.url())) {
                this.config.setUrl(this.client.url());
            }
            if (TextUtils.isNotEmpty(this.client.group())) {
                this.config.setGroup(this.client.group());
            }
            if (TextUtils.isNotEmpty(this.client.name())) {
                this.config.setName(this.client.name());
            }
            if (TextUtils.isNotEmpty(this.client.path())) {
                this.config.setPath(this.client.path());
            }
            if (this.client.headers().length > 0) {
                for (String h : this.client.headers()) {
                    String[] ss = null;
                    ss = h.contains(":") ? h.split(":") : h.split("=");
                    if (ss.length != 2) continue;
                    this.headers0.put(ss[0].trim(), ss[1].trim());
                    this.config.setHeader(ss[0].trim(), ss[1].trim());
                }
            }
            if (this.client.upstream().length > 0) {
                this.config.setUpstream(new UpstreamFixed(Arrays.asList(this.client.upstream())));
            }
        }
        this.config.init();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        Class<?> type;
        Map<String, String> contextMap;
        if (TextUtils.isEmpty(this.config.getUrl()) && this.config.getUpstream() == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("NamiClient: Not found upstream: ").append(this.clz0.getName());
            if (TextUtils.isNotEmpty(this.config.getName())) {
                buf.append(": '").append(this.config.getName()).append("'");
            }
            throw new NamiException(buf.toString());
        }
        if (method.isDefault()) {
            return MethodHandlerUtils.invokeDefault(proxy, method, vals);
        }
        if (method.getDeclaringClass() == Object.class) {
            return MethodHandlerUtils.invokeObject(this.clz0, proxy, method, vals);
        }
        MethodDesc methodWrap = MethodDesc.get(method);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        if (methodWrap.getHeaders() != null) {
            headers.putAll(methodWrap.getHeaders());
        }
        if ((contextMap = NamiAttachment.getData()).size() > 0) {
            headers.putAll(contextMap);
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Object body = null;
        List<ParameterDesc> params = methodWrap.getParameters();
        StringBuilder cookies = new StringBuilder();
        int len = params.size();
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            ParameterDesc pw = params.get(i);
            if (pw.isBody()) {
                body = vals[i];
                continue;
            }
            if (pw.isHeader()) {
                headers.put(pw.getName(), String.valueOf(vals[i]));
                continue;
            }
            if (pw.isCookie()) {
                if (cookies.length() > 0) {
                    cookies.append("; ");
                }
                cookies.append(pw.getName()).append("=").append(vals[i]);
                continue;
            }
            args.put(pw.getName(), vals[i]);
        }
        if (cookies.length() > 0) {
            headers.put("Cookie", cookies.toString());
        }
        String path = method.getName();
        String action = null;
        if (methodWrap.getAction() != null) {
            action = methodWrap.getAction();
        }
        if (methodWrap.getPath() != null) {
            path = methodWrap.getPath();
        }
        String baseUrl = null;
        if (TextUtils.isEmpty(this.config.getUrl())) {
            baseUrl = this.config.getUpstream().get();
            if (baseUrl == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("NamiClient: Upstream not found server instance: ").append(this.clz0.getName());
                if (TextUtils.isEmpty(this.config.getName())) {
                    buf.append(": '").append(this.config.getName()).append("'");
                }
                throw new NamiException(buf.toString());
            }
            if (baseUrl.indexOf("://") < 0) {
                baseUrl = "http://" + baseUrl;
            }
            if (TextUtils.isNotEmpty(this.config.getPath())) {
                int idx = baseUrl.indexOf("/", 9);
                if (idx > 0) {
                    baseUrl = baseUrl.substring(0, idx);
                }
                path = this.config.getPath().endsWith("/") ? this.config.getPath() + path : this.config.getPath() + "/" + path;
            }
        } else {
            baseUrl = this.config.getUrl();
        }
        if (path != null && path.indexOf("{") > 0) {
            Map<String, String> pathKeys = this.buildPathKeys(path);
            for (Map.Entry<String, String> kv : pathKeys.entrySet()) {
                Object arg = args.get(kv.getValue());
                if (arg == null) continue;
                String val = arg.toString();
                path = path.replace(kv.getKey(), val);
                args.remove(kv.getValue());
            }
        }
        if ((type = method.getGenericReturnType()) == null) {
            type = method.getReturnType();
        }
        if (baseUrl.startsWith("sd:")) {
            baseUrl = baseUrl.substring(3);
        }
        Object rst = new Nami(this.config).method(proxy, method).action(action).url(baseUrl, path).callOrThrow(headers, args, body).getObjectOrThrow(type);
        return rst;
    }

    private Map<String, String> buildPathKeys(String path) {
        Map pathKeys = this.pathKeysCached.computeIfAbsent(path, k -> {
            LinkedHashMap<String, String> pks = new LinkedHashMap<String, String>();
            Matcher pm = pathKeyExpr.matcher(path);
            while (pm.find()) {
                pks.put(pm.group(), pm.group(1));
            }
            return pks;
        });
        return pathKeys;
    }
}

