/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.nami.annotation.NamiBody;
import org.noear.nami.annotation.NamiMapping;
import org.noear.nami.common.ParameterWrap;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Consumes;
import org.noear.solon.annotation.Delete;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Patch;
import org.noear.solon.annotation.Post;
import org.noear.solon.annotation.Put;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.UploadedFile;

public class MethodWrap {
    private static final Map<Method, MethodWrap> cached = new ConcurrentHashMap<Method, MethodWrap>();
    private final Method method;
    private final List<ParameterWrap> parameters;
    private final Map<String, String> mappingHeaders;
    private String bodyName;
    private String action;
    private String path;

    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.computeIfAbsent(method, k -> new MethodWrap(method));
        return mw;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ParameterWrap> getParameters() {
        return this.parameters;
    }

    public String getBodyName() {
        return this.bodyName;
    }

    public Map<String, String> getMappingHeaders() {
        return this.mappingHeaders;
    }

    public String getAct() {
        return this.action;
    }

    public String getFun() {
        return this.path;
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = new ArrayList<ParameterWrap>(m.getParameterCount());
        this.mappingHeaders = new HashMap<String, String>();
        if (!this.resolveMethodAnnoByNamiMapping(m)) {
            this.resolveMethodAnnoByMapping(m);
        }
        this.resolveParamAnno(m);
    }

    protected boolean resolveMethodAnnoByNamiMapping(Method m) {
        NamiMapping mappingAnno = m.getAnnotation(NamiMapping.class);
        if (mappingAnno != null) {
            if (mappingAnno.value().length() > 0) {
                String val = mappingAnno.value().trim();
                int idx = val.indexOf(" ");
                if (idx > 0) {
                    this.action = val.substring(0, idx);
                    this.path = val.substring(idx + 1);
                } else {
                    this.action = val;
                }
            }
            if (mappingAnno.headers().length > 0) {
                for (String h : mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.mappingHeaders.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
        return mappingAnno != null;
    }

    protected void resolveMethodAnnoByMapping(Method m) {
        Consumes anno;
        Mapping mappingAnno = m.getAnnotation(Mapping.class);
        if (mappingAnno != null) {
            if (mappingAnno.value().length() > 0) {
                if (mappingAnno.method().length > 0) {
                    this.action = mappingAnno.method()[0].name();
                }
                this.path = Utils.annoAlias((String)mappingAnno.value(), (String)mappingAnno.path());
            }
            if (mappingAnno.headers().length > 0) {
                for (String h : mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.mappingHeaders.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
        if (m.isAnnotationPresent(Post.class)) {
            this.action = MethodType.POST.name();
        }
        if (m.isAnnotationPresent(Get.class)) {
            this.action = MethodType.GET.name();
        }
        if (m.isAnnotationPresent(Put.class)) {
            this.action = MethodType.PUT.name();
        }
        if (m.isAnnotationPresent(Delete.class)) {
            this.action = MethodType.DELETE.name();
        }
        if (m.isAnnotationPresent(Patch.class)) {
            this.action = MethodType.PATCH.name();
        }
        if ((anno = m.getAnnotation(Consumes.class)) != null) {
            this.mappingHeaders.put("Content-Type", anno.value());
        }
    }

    protected void resolveParamAnno(Method m) {
        for (Parameter p1 : m.getParameters()) {
            this.parameters.add(new ParameterWrap(p1));
            NamiBody namiBodyAnno = p1.getAnnotation(NamiBody.class);
            if (namiBodyAnno != null) {
                this.bodyName = p1.getName();
                if (namiBodyAnno.contentType().length() <= 0) break;
                this.mappingHeaders.putIfAbsent("Content-Type", namiBodyAnno.contentType());
                break;
            }
            Body bodyAnno = p1.getAnnotation(Body.class);
            if (bodyAnno != null) {
                this.bodyName = p1.getName();
                break;
            }
            if (!File.class.isAssignableFrom(p1.getType()) && !UploadedFile.class.isAssignableFrom(p1.getType())) continue;
            this.mappingHeaders.put("Content-Type", "multipart/form-data");
        }
    }
}

