/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.nami.annotation.NamiBody;
import org.noear.nami.annotation.NamiMapping;

public class MethodWrap {
    private static final Map<Method, MethodWrap> cached = new ConcurrentHashMap<Method, MethodWrap>();
    private Method method;
    private Parameter[] parameters;
    private String bodyName;
    private NamiBody bodyAnno;
    private NamiMapping mappingAnno;
    private Map<String, String> mappingHeaders;
    private String act;
    private String fun;

    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.computeIfAbsent(method, k -> new MethodWrap(method));
        return mw;
    }

    protected void resolveMappingAnno(Method m) {
        this.mappingAnno = m.getAnnotation(NamiMapping.class);
    }

    protected void resolveBodyAnno(Parameter p1) {
        this.bodyAnno = p1.getAnnotation(NamiBody.class);
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = m.getParameters();
        this.resolveMappingAnno(m);
        for (Parameter p1 : this.parameters) {
            this.resolveBodyAnno(p1);
            if (this.bodyAnno == null) continue;
            this.bodyName = p1.getName();
            break;
        }
        if (this.mappingAnno != null) {
            if (this.mappingAnno.value().length() > 0) {
                String val = this.mappingAnno.value().trim();
                int idx = val.indexOf(" ");
                if (idx > 0) {
                    this.act = val.substring(0, idx);
                    this.fun = val.substring(idx + 1);
                } else {
                    this.act = val;
                }
            }
            if (this.mappingAnno.headers().length > 0) {
                this.mappingHeaders = new HashMap<String, String>();
                for (String h : this.mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.mappingHeaders.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getBodyName() {
        return this.bodyName;
    }

    public NamiBody getBodyAnno() {
        return this.bodyAnno;
    }

    public NamiMapping getMappingAnno() {
        return this.mappingAnno;
    }

    public Map<String, String> getMappingHeaders() {
        return this.mappingHeaders;
    }

    public String getAct() {
        return this.act;
    }

    public String getFun() {
        return this.fun;
    }
}

