/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.noear.nami.annotation.Body;
import org.noear.nami.annotation.Mapping;

public class MethodWrap {
    private static final Map<Method, MethodWrap> cached = new HashMap<Method, MethodWrap>();
    private Method method;
    private Parameter[] parameters;
    private String bodyName;
    private Body bodyAnno;
    private Mapping mappingAnno;
    private Map<String, String> mappingHeaders;
    private String act;
    private String fun;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.get(method);
        if (mw == null) {
            Method method2 = method;
            synchronized (method2) {
                mw = cached.get(method);
                if (mw == null) {
                    mw = new MethodWrap(method);
                    cached.put(method, mw);
                }
            }
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = m.getParameters();
        this.mappingAnno = m.getAnnotation(Mapping.class);
        for (Parameter p1 : this.parameters) {
            this.bodyAnno = p1.getAnnotation(Body.class);
            if (this.bodyAnno == null) continue;
            this.bodyName = p1.getName();
            break;
        }
        if (this.mappingAnno != null) {
            if (this.mappingAnno.value().length() > 0) {
                String val = this.mappingAnno.value().trim();
                if (val.indexOf(" ") > 0) {
                    this.act = val.split(" ")[0];
                    this.fun = val.split(" ")[1];
                } else {
                    this.act = val;
                }
            }
            if (this.mappingAnno.headers().length > 0) {
                this.mappingHeaders = new HashMap<String, String>();
                for (String h : this.mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.mappingHeaders.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getBodyName() {
        return this.bodyName;
    }

    public Body getBodyAnno() {
        return this.bodyAnno;
    }

    public Mapping getMappingAnno() {
        return this.mappingAnno;
    }

    public Map<String, String> getMappingHeaders() {
        return this.mappingHeaders;
    }

    public String getAct() {
        return this.act;
    }

    public String getFun() {
        return this.fun;
    }
}

