/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.nami.Config;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiAttachment;
import org.noear.nami.NamiBuilder;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiException;
import org.noear.nami.NamiManager;
import org.noear.nami.annotation.Mapping;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.MethodHandlesUtil;
import org.noear.nami.common.MethodWrap;
import org.noear.nami.common.TextUtils;
import org.noear.nami.common.UpstreamFixed;

public class NamiHandler
implements InvocationHandler {
    private static final Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");
    private final Config config;
    private final NamiClient client;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final Class<?> clz0;
    private final Map<String, Map> pathKeysCached = new LinkedHashMap<String, Map>();
    private ConcurrentHashMap<Method, MethodHandle> methodHandleMap = new ConcurrentHashMap();

    public NamiHandler(Class<?> clz, Config config, NamiClient client) {
        this.config = config;
        this.client = client;
        this.clz0 = clz;
        try {
            this.init();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws Exception {
        if (this.client != null) {
            for (Filter mi : NamiManager.getFilters()) {
                this.config.filterAdd(mi);
            }
            NamiConfiguration tmp = NamiManager.getConfigurator(this.client.configuration());
            if (tmp != null) {
                tmp.config(this.client, new NamiBuilder(this.config));
            }
            if (this.client.timeout() > 0) {
                this.config.setTimeout(this.client.timeout());
            }
            if (this.client.heartbeat() > 0) {
                this.config.setHeartbeat(this.client.heartbeat());
            }
            if (TextUtils.isNotEmpty(this.client.url())) {
                this.config.setUrl(this.client.url());
            }
            if (TextUtils.isNotEmpty(this.client.group())) {
                this.config.setGroup(this.client.group());
            }
            if (TextUtils.isNotEmpty(this.client.name())) {
                this.config.setName(this.client.name());
            }
            if (TextUtils.isNotEmpty(this.client.path())) {
                this.config.setPath(this.client.path());
            }
            if (this.client.headers().length > 0) {
                for (String h : this.client.headers()) {
                    String[] ss = null;
                    ss = h.contains(":") ? h.split(":") : h.split("=");
                    if (ss.length != 2) continue;
                    this.headers0.put(ss[0].trim(), ss[1].trim());
                }
            }
            if (this.client.upstream().length > 0) {
                this.config.setUpstream(new UpstreamFixed(Arrays.asList(this.client.upstream())));
            }
        }
        this.config.init();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        Class<?> type;
        Map<String, String> contextMap;
        if (TextUtils.isEmpty(this.config.getUrl()) && this.config.getUpstream() == null) {
            throw new NamiException("NamiClient: Not found upstream: " + this.clz0.getName());
        }
        MethodWrap methodWrap = MethodWrap.get(method);
        if (method.isDefault()) {
            MethodHandle defaultMethodHandle = this.methodHandleMap.computeIfAbsent(method, key -> {
                MethodHandle methodHandle = MethodHandlesUtil.getSpecialMethodHandle(method);
                return methodHandle.bindTo(proxy);
            });
            return defaultMethodHandle.invokeWithArguments(vals);
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Object body = null;
        Parameter[] names = methodWrap.getParameters();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            args.put(names[i].getName(), vals[i]);
        }
        if (methodWrap.getBodyName() != null) {
            body = args.get(methodWrap.getBodyName());
            if (this.config.getEncoder() == null) {
                headers.putIfAbsent("Content-Type", methodWrap.getBodyAnno().contentType());
            }
        }
        String fun = method.getName();
        String act = null;
        Mapping mapping = methodWrap.getMappingAnno();
        if (mapping != null) {
            if (methodWrap.getAct() != null) {
                act = methodWrap.getAct();
            }
            if (methodWrap.getFun() != null) {
                fun = methodWrap.getFun();
            }
            if (methodWrap.getMappingHeaders() != null) {
                headers.putAll(methodWrap.getMappingHeaders());
            }
        }
        if ((contextMap = NamiAttachment.getData()).size() > 0) {
            headers.putAll(contextMap);
        }
        String url = null;
        if (TextUtils.isEmpty(this.config.getUrl())) {
            url = this.config.getUpstream().get();
            if (url == null) {
                throw new NamiException("NamiClient: Upstream not found server!");
            }
            if (url.indexOf("://") < 0) {
                url = "http://" + url;
            }
            if (TextUtils.isNotEmpty(this.config.getPath())) {
                int idx = url.indexOf("/", 9);
                if (idx > 0) {
                    url = url.substring(0, idx);
                }
                fun = this.config.getPath().endsWith("/") ? this.config.getPath() + fun : this.config.getPath() + "/" + fun;
            }
        } else {
            url = this.config.getUrl();
        }
        if (fun != null && fun.indexOf("{") > 0) {
            Map<String, String> pathKeys = this.buildPathKeys(fun);
            for (Map.Entry<String, String> kv : pathKeys.entrySet()) {
                String val = (String)args.get(kv.getValue());
                if (val == null) continue;
                fun = fun.replace(kv.getKey(), val);
                args.remove(kv.getValue());
            }
        }
        if ((type = method.getGenericReturnType()) == null) {
            type = method.getReturnType();
        }
        Object rst = new Nami(this.config).method(method).action(act).url(url, fun).call(headers, args, body).getObject(type);
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> buildPathKeys(String path) {
        LinkedHashMap<String, String> pathKeys = this.pathKeysCached.get(path);
        if (pathKeys == null) {
            String string = path.intern();
            synchronized (string) {
                pathKeys = this.pathKeysCached.get(path);
                if (pathKeys == null) {
                    pathKeys = new LinkedHashMap<String, String>();
                    Matcher pm = pathKeyExpr.matcher(path);
                    while (pm.find()) {
                        pathKeys.put(pm.group(), pm.group(1));
                    }
                }
            }
        }
        return pathKeys;
    }
}

