/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Result {
    private int code;
    private List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private Charset charset;
    private byte[] body;
    private String bodyString;

    public Result() {
    }

    public Result(Charset charset, byte[] body) {
        this();
        this.charset = charset;
        this.body = body;
    }

    public Result(int code, byte[] body) {
        this();
        this.code = code;
        this.charset = StandardCharsets.UTF_8;
        this.body = body;
    }

    public void headerAdd(String name, String value) {
        this.headers.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    public String headerGet(String name) {
        if (name != null) {
            for (Map.Entry<String, String> kv : this.headers) {
                if (!name.equals(kv.getKey())) continue;
                return kv.getValue();
            }
        }
        return null;
    }

    public void charsetSet(Charset charset) {
        this.charset = charset;
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return this.headers;
    }

    public int code() {
        return this.code;
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] body() {
        return this.body;
    }

    public String bodyAsString() {
        if (this.bodyString == null) {
            this.bodyString = this.charset == null ? new String(this.body) : new String(this.body, this.charset);
            this.body = null;
        }
        if (this.code >= 400) {
            throw new RuntimeException(this.code + " \u9519\u8bef\uff1a" + this.bodyString);
        }
        return this.bodyString;
    }
}

