/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.noear.nami.Channel;
import org.noear.nami.Config;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Invocation;
import org.noear.nami.NamiBuilder;
import org.noear.nami.NamiException;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nami {
    static final Logger log = LoggerFactory.getLogger(Nami.class);
    public static Encoder defaultEncoder;
    public static Decoder defaultDecoder;
    private String _url;
    private String _action = "POST";
    private Method _method;
    private final Config _config;
    private Result _result;

    public Nami() {
        this._config = new Config().init();
    }

    protected Nami(Config config) {
        this._config = config;
        this._config.init();
    }

    public Nami method(Method method) {
        if (method != null) {
            this._method = method;
        }
        return this;
    }

    public Nami action(String action) {
        if (action != null && action.length() > 0) {
            this._action = action;
        }
        return this;
    }

    public Nami url(String url) {
        this._url = url;
        return this;
    }

    public Nami url(String url, String fun) {
        if (url.indexOf("{fun}") > 0) {
            this._url = url.replace("{fun}", fun);
        } else if (fun == null) {
            this._url = url;
        } else {
            StringBuilder sb = new StringBuilder(200);
            sb.append(url);
            if (url.endsWith("/")) {
                if (fun.startsWith("/")) {
                    sb.append(fun.substring(1));
                } else {
                    sb.append(fun);
                }
            } else if (fun.startsWith("/")) {
                sb.append(fun);
            } else {
                sb.append("/").append(fun);
            }
            this._url = sb.toString();
        }
        return this;
    }

    public Nami call(Map<String, String> headers, Map args) {
        return this.call(headers, args, null);
    }

    public Nami call(Map<String, String> headers, Map args, Object body) {
        try {
            Invocation invocation = new Invocation(this._config, this._method, this._action, this._url, this::callDo);
            if (headers != null) {
                invocation.headers.putAll(headers);
            }
            if (args != null) {
                invocation.args.putAll(args);
            }
            if (body != null) {
                invocation.body = body;
            }
            this._result = invocation.invoke();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    private Result callDo(Invocation inv) throws Throwable {
        int idx;
        Channel channel = this._config.getChannel();
        if (channel == null && (idx = inv.url.indexOf("://")) > 0) {
            String scheme = inv.url.substring(0, idx);
            channel = NamiManager.getChannel(scheme);
        }
        if (channel == null) {
            throw new NamiException("There are no channels available");
        }
        if (inv.body == null) {
            inv.body = inv.args;
        }
        log.trace("Nami call: {}", (Object)inv.url);
        return channel.call(inv);
    }

    public Result result() {
        return this._result;
    }

    public String getString() {
        if (this._result == null) {
            return null;
        }
        return this._result.bodyAsString();
    }

    public <T> T getObject(Type returnType) {
        if (this._result == null) {
            return null;
        }
        if (Void.TYPE.equals(returnType)) {
            return null;
        }
        Decoder decoder = this._config.getDecoder();
        if (decoder == null) {
            decoder = NamiManager.getDecoder("application/json");
        }
        return decoder.decode(this._result, returnType);
    }

    public static NamiBuilder builder() {
        return new NamiBuilder();
    }
}

