/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.noear.nami.Channel;
import org.noear.nami.Config;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiException;
import org.noear.nami.NamiHandler;
import org.noear.nami.annotation.NamiClient;

public class NamiBuilder {
    private final Config _config;

    protected NamiBuilder() {
        this._config = new Config();
    }

    protected NamiBuilder(Config config) {
        this._config = config;
    }

    public NamiBuilder upstream(Supplier<String> upstream) {
        this._config.setUpstream(upstream);
        return this;
    }

    public NamiBuilder encoder(Encoder encoder) {
        this._config.setEncoder(encoder);
        return this;
    }

    public NamiBuilder decoder(Decoder decoder) {
        this._config.setDecoder(decoder);
        return this;
    }

    public NamiBuilder headerSet(String name, String val) {
        this._config.setHeader(name, val);
        return this;
    }

    public NamiBuilder channel(Channel channel) {
        this._config.setChannel(channel);
        return this;
    }

    public NamiBuilder filterAdd(Filter filter) {
        this._config.filterAdd(filter);
        return this;
    }

    public NamiBuilder url(String url) {
        this._config.setUrl(url);
        return this;
    }

    public NamiBuilder name(String name) {
        this._config.setName(name);
        return this;
    }

    public NamiBuilder path(String path) {
        this._config.setPath(path);
        return this;
    }

    public NamiBuilder group(String group) {
        this._config.setGroup(group);
        return this;
    }

    public Nami build() {
        return new Nami(this._config);
    }

    public <T> T create(Class<?> clz) {
        NamiClient client = clz.getAnnotation(NamiClient.class);
        return (T)this.create(clz, client);
    }

    public Object create(Class<?> clz, NamiClient client) {
        if (clz == null) {
            return null;
        }
        if (!clz.isInterface()) {
            throw new NamiException("NamiClient only support interfaces");
        }
        NamiHandler handler = new NamiHandler(clz, this._config, client);
        return Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)handler);
    }
}

