/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.HashMap;
import java.util.Map;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfiguration;

public class NamiManager {
    static final Map<String, Decoder> decoderMap = new HashMap<String, Decoder>();
    static final Map<String, Encoder> encoderMap = new HashMap<String, Encoder>();
    static final Map<String, NamiChannel> channelMap = new HashMap<String, NamiChannel>();
    static final Map<Class<?>, NamiConfiguration> configuratorMap = new HashMap();

    public static void reg(Decoder decoder) {
        decoderMap.put(decoder.enctype(), decoder);
    }

    public static void regIfAbsent(Decoder decoder) {
        decoderMap.putIfAbsent(decoder.enctype(), decoder);
    }

    public static void reg(Encoder encoder) {
        encoderMap.put(encoder.enctype(), encoder);
    }

    public static void regIfAbsent(Encoder encoder) {
        encoderMap.putIfAbsent(encoder.enctype(), encoder);
    }

    public static void reg(String scheme, NamiChannel namiChannel) {
        channelMap.put(scheme, namiChannel);
    }

    public static void regIfAbsent(String scheme, NamiChannel namiChannel) {
        channelMap.putIfAbsent(scheme, namiChannel);
    }

    public static Decoder getDecoder(String enctype) {
        return decoderMap.get(enctype);
    }

    public static Encoder getEncoder(String enctype) {
        return encoderMap.get(enctype);
    }

    public static NamiChannel getChannel(String scheme) {
        return channelMap.get(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamiConfiguration getConfigurator(Class<? extends NamiConfiguration> clz) throws Exception {
        NamiConfiguration tmp = configuratorMap.get(clz);
        if (tmp == null) {
            Class<? extends NamiConfiguration> clazz = clz;
            synchronized (clazz) {
                tmp = configuratorMap.get(clz);
                if (tmp == null) {
                    tmp = clz.newInstance();
                    configuratorMap.put(clz, tmp);
                }
            }
        }
        return tmp;
    }
}

