/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.noear.nami.Channel;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiManager;

public class Config {
    private boolean debug;
    private int timeout;
    private Encoder encoder;
    private Decoder decoder;
    private Channel channel;
    private Supplier<String> upstream;
    private String url;
    private String name;
    private String path;
    private String group;
    private Set<Filter> filters = new LinkedHashSet<Filter>();
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    public Config() {
        this.encoder = Nami.defaultEncoder;
        this.decoder = Nami.defaultDecoder;
    }

    protected Config init() {
        String ct;
        if (this.decoder == null) {
            String at = this.headers.get("Accept");
            if (at != null) {
                this.decoder = NamiManager.getDecoder(at);
            }
            if (this.decoder == null) {
                this.setDecoder(NamiManager.getDecoder("application/json"));
            }
        }
        if (this.encoder == null && (ct = this.headers.get("Content-Type")) != null) {
            this.encoder = NamiManager.getEncoder(ct);
        }
        return this;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        if (encoder != null) {
            this.encoder = encoder;
        }
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        if (decoder != null) {
            this.decoder = decoder;
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Supplier<String> getUpstream() {
        return this.upstream;
    }

    protected void setUpstream(Supplier<String> upstream) {
        this.upstream = upstream;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    protected void setHeader(String name, String val) {
        this.headers.put(name, val);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    protected void filterAdd(Filter filter) {
        this.filters.add(filter);
    }
}

