/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.nami.Nami;
import org.noear.nami.NamiAttachment;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiException;
import org.noear.nami.annotation.Mapping;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.MethodWrap;
import org.noear.nami.common.TextUtils;
import org.noear.nami.common.UpstreamFixed;

public class NamiHandler
implements InvocationHandler {
    private static Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");
    private final NamiConfig config;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final Class<?> clz0;
    private final Map<String, Map> pathKeysCached = new ConcurrentHashMap<String, Map>();
    protected MethodHandles.Lookup lookup;

    public NamiHandler(Class<?> clz, NamiConfig config, NamiClient client) {
        this.config = config;
        this.clz0 = clz;
        if (client != null) {
            try {
                config.setUrl(config.getUrl());
                NamiConfiguration tmp = client.configuration().newInstance();
                if (tmp != null) {
                    tmp.config(client, new Nami.Builder(config));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (client.timeout() > 0) {
                config.setTimeout(client.timeout());
            }
            if (TextUtils.isNotEmpty(client.url())) {
                config.setUrl(client.url());
            }
            if (TextUtils.isNotEmpty(client.group())) {
                config.setGroup(client.group());
            }
            if (TextUtils.isNotEmpty(client.name())) {
                config.setName(client.name());
            }
            if (TextUtils.isNotEmpty(client.path())) {
                config.setPath(client.path());
            }
            if (client.headers().length > 0) {
                for (String h : client.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.headers0.put(ss[0].trim(), ss[1].trim());
                }
            }
            if (client.upstream().length > 0) {
                config.setUpstream(new UpstreamFixed(Arrays.asList(client.upstream())));
            }
        }
        config.init();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        Class<?> type;
        NamiAttachment namiAttachment = NamiAttachment.currentGet();
        if (namiAttachment != null && namiAttachment.autoRemove()) {
            NamiAttachment.currentRemove();
        }
        if (TextUtils.isEmpty(this.config.getUrl()) && this.config.getUpstream() == null) {
            throw new NamiException("NamiClient: Not found upstream: " + this.clz0.getName());
        }
        MethodWrap methodWrap = MethodWrap.get(method);
        Class<?> caller = method.getDeclaringClass();
        if (Object.class == caller) {
            if (this.lookup == null) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                this.lookup = (MethodHandles.Lookup)constructor.newInstance(caller, 2);
            }
            return this.lookup.unreflectSpecial(method, caller).bindTo(proxy).invokeWithArguments(vals);
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Object body = null;
        Parameter[] names = methodWrap.getParameters();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            args.put(names[i].getName(), vals[i]);
        }
        if (methodWrap.getBodyName() != null) {
            body = args.get(methodWrap.getBodyName());
            if (this.config.getEncoder() == null) {
                headers.putIfAbsent("Content-Type", methodWrap.getBodyAnno().contentType());
            }
        }
        String fun = method.getName();
        String act = null;
        Mapping mapping = methodWrap.getMappingAnno();
        if (mapping != null) {
            if (methodWrap.getAct() != null) {
                act = methodWrap.getAct();
            }
            if (methodWrap.getFun() != null) {
                fun = methodWrap.getFun();
            }
            if (methodWrap.getMappingHeaders() != null) {
                headers.putAll(methodWrap.getMappingHeaders());
            }
        }
        if (namiAttachment != null) {
            headers.putAll(namiAttachment.headers());
        }
        String url = null;
        if (TextUtils.isEmpty(this.config.getUrl())) {
            url = this.config.getUpstream().get();
            if (url == null) {
                throw new NamiException("NamiClient: Upstream not found server!");
            }
            if (url.indexOf("://") < 0) {
                url = "http://";
            }
            if (TextUtils.isNotEmpty(this.config.getPath())) {
                int idx = url.indexOf("/", 9);
                if (idx > 0) {
                    url = url.substring(0, idx);
                }
                fun = this.config.getPath().endsWith("/") ? this.config.getPath() + fun : this.config.getPath() + "/" + fun;
            }
        } else {
            url = this.config.getUrl();
        }
        if (fun != null && fun.indexOf("{") > 0) {
            Map<String, String> pathKeys = this.buildPathKeys(fun);
            for (Map.Entry<String, String> kv : pathKeys.entrySet()) {
                String val = (String)args.get(kv.getValue());
                if (val == null) continue;
                fun = fun.replace(kv.getKey(), val);
                args.remove(kv.getValue());
            }
        }
        if ((type = method.getGenericReturnType()) == null) {
            type = method.getReturnType();
        }
        return new Nami(this.config).method(method).action(act).url(url, fun).call(headers, args, body).getObject(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> buildPathKeys(String path) {
        LinkedHashMap<String, String> pathKeys = this.pathKeysCached.get(path);
        if (pathKeys == null) {
            String string = path.intern();
            synchronized (string) {
                pathKeys = this.pathKeysCached.get(path);
                if (pathKeys == null) {
                    pathKeys = new LinkedHashMap<String, String>();
                    Matcher pm = pathKeyExpr.matcher(path);
                    while (pm.find()) {
                        pathKeys.put(pm.group(), pm.group(1));
                    }
                }
            }
        }
        return pathKeys;
    }
}

