/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.noear.nami.NamiException;

class HttpUtils {
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).readTimeout(300L, TimeUnit.SECONDS).dispatcher(HttpUtils.dispatcher()).build();
    private String _url;
    private Charset _charset;
    private Map<String, String> _cookies;
    private RequestBody _body;
    private Map<String, String> _form;
    private MultipartBody.Builder _part_builer;
    private Request.Builder _builder;

    private static final Dispatcher dispatcher() {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(3000);
        temp.setMaxRequestsPerHost(600);
        return temp;
    }

    public static HttpUtils http(String url) {
        return new HttpUtils(url);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new NamiException(ex);
        }
    }

    public HttpUtils(String url) {
        this._url = url;
        this._builder = new Request.Builder().url(url);
    }

    public HttpUtils userAgent(String ua) {
        this._builder.header("User-Agent", ua);
        return this;
    }

    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> this._builder.header(k, v));
        }
        return this;
    }

    public HttpUtils header(String name, String value) {
        if (name != null) {
            this._builder.header(name, value);
        }
        return this;
    }

    public HttpUtils data(Map<String, Object> data) {
        if (data != null) {
            this.tryInitForm();
            data.forEach((k, v) -> {
                if (v != null) {
                    this._form.put((String)k, v.toString());
                }
            });
        }
        return this;
    }

    public HttpUtils data(String key, String value) {
        this.tryInitForm();
        this._form.put(key, value);
        return this;
    }

    public HttpUtils data(String key, String filename, InputStream inputStream, String contentType) {
        this.tryInitPartBuilder(MultipartBody.FORM);
        this._part_builer.addFormDataPart(key, filename, (RequestBody)new StreamBody(contentType, inputStream));
        return this;
    }

    public HttpUtils bodyTxt(String txt, String contentType) {
        this._body = contentType == null ? FormBody.create(null, (String)txt) : FormBody.create((MediaType)MediaType.parse((String)contentType), (String)txt);
        return this;
    }

    public HttpUtils bodyRaw(InputStream raw, String contentType) {
        this._body = new StreamBody(contentType, raw);
        return this;
    }

    public HttpUtils cookies(Map<String, Object> cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            cookies.forEach((k, v) -> this._cookies.put((String)k, v.toString()));
        }
        return this;
    }

    public Response exec(String mothod) throws Exception {
        if (this._part_builer != null) {
            if (this._form != null) {
                this._form.forEach((k, v) -> this._part_builer.addFormDataPart(k, v));
            }
            this._body = this._part_builer.build();
        } else if (this._form != null) {
            Object fb = new FormBody.Builder(this._charset);
            this._form.forEach((arg_0, arg_1) -> HttpUtils.lambda$exec$4((FormBody.Builder)fb, arg_0, arg_1));
            this._body = fb.build();
        }
        if (this._cookies != null) {
            this._builder.header("Cookie", HttpUtils.getRequestCookieString(this._cookies));
        }
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new RuntimeException("This method is not supported");
            }
        }
        Call call = httpClient.newCall(this._builder.build());
        return call.execute();
    }

    public String exec2(String mothod) throws Exception {
        Response tmp = this.exec(mothod);
        int code = tmp.code();
        String text = tmp.body().string();
        if (code >= 200 && code <= 300) {
            return text;
        }
        throw new RuntimeException(code + "\u9519\u8bef\uff1a" + text);
    }

    public String get() throws Exception {
        return this.exec2("GET");
    }

    public String post() throws Exception {
        return this.exec2("POST");
    }

    public String put() throws Exception {
        return this.exec2("PUT");
    }

    public String patch() throws Exception {
        return this.exec2("PATCH");
    }

    public String delete() throws Exception {
        return this.exec2("DELETE");
    }

    private static String getRequestCookieString(Map<String, String> cookies) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> kv : cookies.entrySet()) {
            sb.append(kv.getKey()).append('=').append(kv.getValue());
            if (!first) {
                sb.append("; ");
                continue;
            }
            first = false;
        }
        return sb.toString();
    }

    private void tryInitPartBuilder(MediaType type) {
        if (this._part_builer == null) {
            this._part_builer = new MultipartBody.Builder().setType(type);
        }
    }

    private void tryInitForm() {
        if (this._form == null) {
            this._form = new HashMap<String, String>();
        }
    }

    private void tryInitCookies() {
        if (this._cookies == null) {
            this._cookies = new HashMap<String, String>();
        }
    }

    private static /* synthetic */ void lambda$exec$4(FormBody.Builder fb, String k, String v) {
        fb.add(k, v);
    }

    public static class StreamBody
    extends RequestBody {
        private MediaType _contentType = null;
        private InputStream _inputStream = null;

        public StreamBody(String contentType, InputStream inputStream) {
            if (contentType != null) {
                this._contentType = MediaType.parse((String)contentType);
            }
            this._inputStream = inputStream;
        }

        public MediaType contentType() {
            return this._contentType;
        }

        public long contentLength() throws IOException {
            return this._inputStream.available();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this._inputStream);
                sink.writeAll(source);
            }
            finally {
                Util.closeQuietly((Closeable)source);
            }
        }
    }
}

