/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.nami.Nami;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiException;
import org.noear.nami.annotation.Mapping;
import org.noear.nami.annotation.NamiClient;

public class NamiHandler
implements InvocationHandler {
    private final NamiConfig config;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final String name0;
    private final String path0;
    private final String url0;
    protected MethodHandles.Lookup lookup;

    public NamiHandler(Class<?> clz, NamiConfig config, NamiClient client) {
        this.config = config;
        if (client != null) {
            try {
                NamiConfiguration tmp = client.configuration().newInstance();
                if (tmp != null) {
                    tmp.config(client, new Nami.Builder(config));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (client.headers() != null) {
                for (String h : client.headers()) {
                    String[] ss = h.split("=");
                    this.headers0.put(ss[0], ss[1]);
                }
            }
        }
        config.tryInit();
        String uri = config.getUri();
        if (uri == null && client != null && !NamiHandler.isEmpty(client.value())) {
            uri = client.value();
        }
        if (uri == null) {
            throw new NamiException("FairyClient config is wrong: " + clz.getName());
        }
        if (uri.contains("://")) {
            this.url0 = uri;
            this.name0 = null;
            this.path0 = null;
        } else if (uri.contains(":")) {
            this.url0 = null;
            this.name0 = uri.split(":")[0];
            this.path0 = uri.split(":")[1];
        } else {
            this.url0 = null;
            this.name0 = uri;
            this.path0 = null;
        }
        if (this.url0 == null && config.getUpstream() == null) {
            throw new NamiException("FairyClient: Not found upstream: " + clz.getName());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        Class<?> caller = method.getDeclaringClass();
        if (Object.class == caller) {
            if (this.lookup == null) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                this.lookup = (MethodHandles.Lookup)constructor.newInstance(caller, 2);
            }
            return this.lookup.unreflectSpecial(method, caller).bindTo(proxy).invokeWithArguments(vals);
        }
        String fun = method.getName();
        String act = null;
        Mapping mapping = method.getAnnotation(Mapping.class);
        if (mapping != null && !NamiHandler.isEmpty(mapping.value())) {
            String val = mapping.value().trim();
            if (val.indexOf(" ") > 0) {
                act = val.split(" ")[0];
                fun = val.split(" ")[1];
            } else {
                act = val;
            }
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Parameter[] names = method.getParameters();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            args.put(names[i].getName(), vals[i]);
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        String url = null;
        if (this.url0 == null) {
            url = this.config.getUpstream().get();
            if (url == null) {
                throw new NamiException("FairyClient: Not found upstream!");
            }
            if (this.path0 != null) {
                int idx = url.indexOf("/", 9);
                if (idx > 0) {
                    url = url.substring(0, idx);
                }
                fun = this.path0.endsWith("/") ? this.path0 + fun : this.path0 + "/" + fun;
            }
        } else {
            url = this.url0;
        }
        return new Nami(this.config).method(method).action(act).url(url, fun).call(headers, args).getObject(method.getReturnType());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

