/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Response;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfig;
import org.noear.nami.Result;
import org.noear.nami.channel.OkHttpUtils;

public class OkHttpChannel
implements NamiChannel {
    public static final OkHttpChannel instance = new OkHttpChannel();

    @Override
    public Result call(NamiConfig cfg, Method method, String action, String url, Map<String, String> headers, Map<String, Object> args) throws Throwable {
        boolean is_get = "GET".equals(action);
        if (is_get && args.size() > 0) {
            StringBuilder sb = new StringBuilder(url).append("?");
            args.forEach((k, v) -> {
                if (v != null) {
                    sb.append((String)k).append("=").append(OkHttpUtils.urlEncode(v.toString())).append("&");
                }
            });
            url = sb.substring(0, sb.length() - 1);
        }
        cfg.getDecoder().filter(cfg, action, url, headers, args);
        OkHttpUtils http = OkHttpUtils.http(url).headers(headers);
        Response response = null;
        if (is_get) {
            response = http.exec("GET");
        } else {
            switch (cfg.getEncoder().enctype()) {
                case application_json: {
                    String json = (String)cfg.getEncoder().encode(args);
                    response = http.bodyTxt(json, "application/json").exec(action);
                    break;
                }
                case application_hessian: {
                    ByteArrayInputStream stream = new ByteArrayInputStream((byte[])cfg.getEncoder().encode(args));
                    response = http.bodyRaw(stream, "application/hessian").exec(action);
                    break;
                }
                default: {
                    response = args.size() == 0 ? http.exec("GET") : http.data(args).exec(action);
                }
            }
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.body().bytes());
        int len = response.headers().size();
        for (int i = 0; i < len; ++i) {
            result.headerAdd(response.headers().name(i), response.headers().value(i));
        }
        MediaType contentType = response.body().contentType();
        if (contentType != null) {
            result.charsetSet(contentType.charset());
        }
        return result;
    }
}

