/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiException;
import org.noear.nami.NamiHandler;
import org.noear.nami.NamiManager;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.Result;

public class Nami {
    public static Encoder defaultEncoder;
    public static Decoder defaultDecoder;
    private String _url;
    private String _action = "POST";
    private Method _method;
    private final NamiConfig _config;
    private Result _result;

    public Nami() {
        this._config = new NamiConfig().init();
    }

    protected Nami(NamiConfig config) {
        this._config = config;
        config.init();
    }

    public Nami method(Method method) {
        if (method != null) {
            this._method = method;
        }
        return this;
    }

    public Nami action(String action) {
        if (action != null && action.length() > 0) {
            this._action = action;
        }
        return this;
    }

    public Nami url(String url) {
        this._url = url;
        return this;
    }

    public Nami url(String url, String fun) {
        if (url.indexOf("{fun}") > 0) {
            this._url = url.replace("{fun}", fun);
        } else if (fun == null) {
            this._url = url;
        } else {
            StringBuilder sb = new StringBuilder(200);
            sb.append(url);
            if (url.endsWith("/")) {
                if (fun.startsWith("/")) {
                    sb.append(fun.substring(1));
                } else {
                    sb.append(fun);
                }
            } else if (fun.startsWith("/")) {
                sb.append(fun);
            } else {
                sb.append("/").append(fun);
            }
            this._url = sb.toString();
        }
        return this;
    }

    public Nami call(Map<String, String> headers, Map args) {
        return this.call(headers, args, null);
    }

    public Nami call(Map<String, String> headers, Map args, Object body) {
        try {
            int idx;
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            if (args == null) {
                args = new HashMap<String, Object>();
            }
            for (Filter filter : this._config.getFilters()) {
                filter.filter(this._config, this._action, this._url, headers, args);
            }
            NamiChannel channel = this._config.getChannel();
            if (channel == null && (idx = this._url.indexOf("://")) > 0) {
                String scheme = this._url.substring(0, idx);
                channel = NamiManager.getChannel(scheme);
            }
            if (channel == null) {
                throw new NamiException("There are no channels available");
            }
            channel.filter(this._config, this._action, this._url, headers, args);
            if (body == null) {
                body = args;
            }
            this._result = channel.call(this._config, this._method, this._action, this._url, headers, args, body);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    public Result result() {
        return this._result;
    }

    public String getString() {
        if (this._result == null) {
            return null;
        }
        return this._result.bodyAsString();
    }

    public <T> T getObject(Type returnType) {
        if (this._result == null) {
            return null;
        }
        if (Void.TYPE.equals(returnType)) {
            return null;
        }
        Decoder decoder = this._config.getDecoder();
        if (decoder == null) {
            decoder = NamiManager.getDecoder("application/json");
        }
        return decoder.decode(this._result, returnType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final NamiConfig _config;

        protected Builder() {
            this._config = new NamiConfig();
        }

        protected Builder(NamiConfig config) {
            this._config = config;
        }

        public Builder upstream(Supplier<String> upstream) {
            this._config.setUpstream(upstream);
            return this;
        }

        public Builder encoder(Encoder encoder) {
            this._config.setEncoder(encoder);
            return this;
        }

        public Builder decoder(Decoder decoder) {
            this._config.setDecoder(decoder);
            return this;
        }

        public Builder headerSet(String name, String val) {
            this._config.setHeader(name, val);
            return this;
        }

        public Builder channel(NamiChannel channel) {
            this._config.setChannel(channel);
            return this;
        }

        public Builder filterAdd(Filter filter) {
            this._config.filterAdd(filter);
            return this;
        }

        public Builder url(String url) {
            this._config.setUrl(url);
            return this;
        }

        public Builder name(String name) {
            this._config.setName(name);
            return this;
        }

        public Builder path(String path) {
            this._config.setPath(path);
            return this;
        }

        public Builder group(String group) {
            this._config.setGroup(group);
            return this;
        }

        public Nami build() {
            return new Nami(this._config);
        }

        public <T> T create(Class<?> clz) {
            NamiClient client = clz.getAnnotation(NamiClient.class);
            return (T)this.create(clz, client);
        }

        public Object create(Class<?> clz, NamiClient client) {
            if (clz == null) {
                return null;
            }
            if (!clz.isInterface()) {
                throw new NamiException("NamiClient only support interfaces");
            }
            NamiHandler handler = new NamiHandler(clz, this._config, client);
            return Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)handler);
        }
    }
}

