/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiManager;

public class NamiConfig {
    private Encoder encoder;
    private Decoder decoder;
    private NamiChannel channel;
    private Supplier<String> upstream;
    private String uri;
    private Set<Filter> filters = new LinkedHashSet<Filter>();
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    public NamiConfig() {
        this.encoder = Nami.defaultEncoder;
        this.decoder = Nami.defaultDecoder;
    }

    public NamiConfig tryInit() {
        if (this.decoder == null) {
            this.setDecoder(NamiManager.getDecoder("application/json"));
        }
        return this;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        if (encoder != null) {
            this.encoder = encoder;
        }
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        if (decoder != null) {
            this.decoder = decoder;
        }
    }

    public NamiChannel getChannel() {
        return this.channel;
    }

    public void setChannel(NamiChannel channel) {
        this.channel = channel;
    }

    public Supplier<String> getUpstream() {
        return this.upstream;
    }

    protected void setUpstream(Supplier<String> upstream) {
        this.upstream = upstream;
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    protected void setHeader(String name, String val) {
        this.headers.put(name, val);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    protected void filterAdd(Filter filter) {
        this.filters.add(filter);
    }
}

