/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.Nami;
import org.noear.nami.NamiChannel;
import org.noear.nami.channel.http.HttpChannel;
import org.noear.nami.decoder.FastjsonDecoder;
import org.noear.nami.decoder.SnackDecoder;
import org.noear.nami.encoder.FormEncoder;

public class NamiConfig {
    private static boolean HAS_SNACK3 = NamiConfig.hasClass("org.noear.snack.ONode");
    private static boolean HAS_FASTJSON = NamiConfig.hasClass("com.alibaba.fastjson.JSONObject");
    private Encoder encoder;
    private Decoder decoder;
    private NamiChannel channel;
    private Supplier<String> upstream;
    private String uri;
    private Set<Filter> filters = new LinkedHashSet<Filter>();

    public NamiConfig() {
        this.encoder = Nami.defaultEncoder;
        this.decoder = Nami.defaultDecoder;
        this.channel = Nami.defaultChannel;
    }

    public NamiConfig tryInit() {
        if (this.encoder == null) {
            this.setEncoder(FormEncoder.instance);
        }
        if (this.decoder == null) {
            if (HAS_FASTJSON) {
                this.setDecoder(FastjsonDecoder.instance);
            } else if (HAS_SNACK3) {
                this.setDecoder(SnackDecoder.instance);
            }
        }
        if (this.channel == null) {
            this.setChannel(HttpChannel.instance);
        }
        return this;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(Encoder encoder) {
        if (encoder != null) {
            this.encoder = encoder;
        }
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(Decoder decoder) {
        if (decoder != null) {
            this.decoder = decoder;
        }
    }

    public NamiChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(NamiChannel channel) {
        if (channel != null) {
            this.channel = channel;
        }
    }

    public Supplier<String> getUpstream() {
        return this.upstream;
    }

    protected void setUpstream(Supplier<String> upstream) {
        this.upstream = upstream;
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    protected void filterAdd(Filter filter) {
        this.filters.add(filter);
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

