/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.exception.NamiDecodeException;
import org.noear.solon.Utils;

public class Fastjson2Decoder
implements Decoder {
    public static final Fastjson2Decoder instance = new Fastjson2Decoder();

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        if (rst.body().length == 0) {
            return null;
        }
        String str = rst.bodyAsString();
        if ("null".equals(str)) {
            return null;
        }
        try {
            if (str.contains("\"stackTrace\":[{")) {
                return (T)JSON.parseObject((String)str, Throwable.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
            }
            if (String.class == type && Utils.isNotEmpty((String)str) && str.charAt(0) != '\'' && str.charAt(0) != '\"') {
                return (T)str;
            }
            return (T)JSON.parseObject((String)str, (Type)type, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
        }
        catch (Throwable ex) {
            throw new NamiDecodeException("Decoding failure, type: " + type.getTypeName() + ", data: " + str, ex);
        }
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@type_json");
        }
        ctx.headers.put("Accept", "application/json");
    }
}

