/*
 * Decompiled with CFR 0.152.
 */
package org.noear.java_cron;

import java.text.ParseException;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.noear.java_cron.CronExpressionPlus;

public class CronUtils {
    private static final Map<String, CronExpressionPlus> cached = new HashMap<String, CronExpressionPlus>();

    public static CronExpressionPlus get(String cron) {
        try {
            return CronUtils.get0(cron);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cron parsing failed: " + cron, e);
        }
    }

    public static Date getNextTime(String cron, Date baseTime) throws ParseException {
        return CronUtils.get(cron).getNextValidTimeAfter(baseTime);
    }

    public static boolean isValid(String cron) {
        try {
            return CronUtils.get0(cron) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CronExpressionPlus get0(String cron) throws ParseException {
        CronExpressionPlus expr = cached.get(cron);
        if (expr == null) {
            Map<String, CronExpressionPlus> map = cached;
            synchronized (map) {
                expr = cached.get(cron);
                if (expr == null) {
                    expr = CronUtils.build0(cron);
                    cached.put(cron, expr);
                }
            }
        }
        return expr;
    }

    private static CronExpressionPlus build0(String cron) throws ParseException {
        CronExpressionPlus expr;
        int tzIdx = cron.lastIndexOf(32);
        String tzTmp = cron.substring(tzIdx + 1);
        if (tzTmp.startsWith("-") || tzTmp.startsWith("+")) {
            cron = cron.substring(0, tzIdx);
            expr = new CronExpressionPlus(cron);
            expr.setTimeZone(TimeZone.getTimeZone(ZoneId.of(tzTmp)));
        } else {
            expr = new CronExpressionPlus(cron);
        }
        return expr;
    }
}

